% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enricher.R
\name{enricher}
\alias{enricher}
\title{enricher}
\usage{
enricher(
  gene,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe = NULL,
  minGSSize = 10,
  maxGSSize = 500,
  qvalueCutoff = 0.2,
  gson = NULL,
  TERM2GENE,
  TERM2NAME = NA
)
}
\arguments{
\item{gene}{a vector of gene id}

\item{pvalueCutoff}{adjusted pvalue cutoff on enrichment tests to report}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"}

\item{universe}{background genes. If missing, the all genes listed in the database (eg TERM2GENE table) will be used as background.}

\item{minGSSize}{minimal size of genes annotated for testing}

\item{maxGSSize}{maximal size of genes annotated for testing}

\item{qvalueCutoff}{qvalue cutoff on enrichment tests to report as significant.  Tests must pass i) \code{pvalueCutoff} on unadjusted pvalues, ii) \code{pvalueCutoff} on adjusted pvalues and iii) \code{qvalueCutoff} on qvalues to be reported.}

\item{gson}{a GSON object, if not NULL, use it as annotation data.}

\item{TERM2GENE}{user input annotation of TERM TO GENE mapping, a data.frame of 2 column with term and gene.
Only used when gson is NULL.}

\item{TERM2NAME}{user input of TERM TO NAME mapping, a data.frame of 2 column with term and name.
Only used when gson is NULL.}
}
\value{
A \code{enrichResult} instance
}
\description{
A universal enrichment analyzer
}
\author{
Guangchuang Yu \url{https://yulab-smu.top}
}
