% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cBioCache-defunct}
\alias{cBioCache-defunct}
\alias{removeDataCache}
\title{Defunct cache helper functions}
\usage{
removeDataCache(
  api,
  studyId = NA_character_,
  genePanelId = NA_character_,
  genes = NA_character_,
  molecularProfileIds = NULL,
  sampleListId = NULL,
  sampleIds = NULL,
  by = c("entrezGeneId", "hugoGeneSymbol"),
  dry.run = TRUE,
  ...
)
}
\arguments{
\item{api}{An API object of class \code{cBioPortal} from the \code{cBioPortal} function}

\item{studyId}{\code{character(1)} Indicates the "studyId" as taken from
\code{getStudies}}

\item{genePanelId}{\code{character(1)} Identifies the gene panel, as obtained from
the \code{genePanels} function}

\item{genes}{\code{character()} Either Entrez gene identifiers or Hugo gene
symbols. When included, the 'by' argument indicates the type of identifier
provided and 'genePanelId' is ignored. Preference is given to Entrez IDs
due to faster query responses.}

\item{molecularProfileIds}{\code{character()} A vector of molecular profile IDs}

\item{sampleListId}{\code{character(1)} A sample list identifier as obtained from
\code{sampleLists()}}

\item{sampleIds}{\code{character()} Sample identifiers}

\item{by}{\code{character(1)} Either 'entrezGeneId' or 'hugoGeneSymbol' for row
metadata (default: 'entrezGeneId')}

\item{dry.run}{logical Whether or not to remove cache files (default TRUE).}

\item{...}{Additional arguments to lower level API functions}
}
\value{
removeDataCache: The path to the cache location when
\code{dry.run = FALSE} if the file exists. Otherwise, when \code{dry.run = TRUE},
the function return the output of the \code{file.remove} operation.
}
\description{
\code{cBioPortalData} no longer caches data from API responses;
therefore, \code{removeDataCache} is no longer needed. It will be removed
as soon as the next release of Bioconductor.
}
\section{removeDataCache}{

Remove the computed cache location based on the function inputs to
\code{cBioPortalData()}. To remove the cache, simply replace the
\code{cBiocPortalData()} function name with \code{removeDataCache()}; see the example.
If the computed cache location is not found, it will return an empty vector.
}

\examples{

cbio <- cBioPortal()

cBioPortalData(
    cbio, by = "hugoGeneSymbol",
    studyId = "acc_tcga",
    genePanelId = "AmpliSeq",
    molecularProfileIds =
        c("acc_tcga_rppa", "acc_tcga_linear_CNA", "acc_tcga_mutations")
)

}
