% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareAnnotations.R
\name{prepareAnnotations}
\alias{prepareAnnotations}
\title{prepare reference annotations for long read RNA-Seq analysis with Bambu}
\usage{
prepareAnnotations(x)
}
\arguments{
\item{x}{A path to gtf file or a \code{TxDb} object.}
}
\value{
A \code{GRangesList} object with additional details for each exon and transcript 
that are required by Bambu. Exons are ranked by the \code{exon_rank} column, corresponding 
to the rank in direction of transcription (from first to last exon). In addition to exon rank, 
gene id, transcript id, and the minimum transcript equivalent class is stored as well
(a transcript equivalence class of a transcript x is the collection of transcripts 
where their exon junctions contain, in a continuous way, the exon junctions of the transcript x). 
The object is designed to be used by Bambu, and the direct access of the metadata is not recommended.
}
\description{
prepare reference annotations for long read RNA-Seq analysis with Bambu
}
\details{
This function creates a reference annotation object which is used for transcript 
discovery and quantification in Bambu. prepareAnnotations can use a path to a gtf file
or a TxDB object as input, and returns a annotation object that stores additional
information about transcripts which is used in Bambu. For each transcript, exons
are ranked from first to last exon in direction of transcription.
}
\examples{
gtf.file <- system.file("extdata",
    "Homo_sapiens.GRCh38.91_chr9_1_1000000.gtf",
    package = "bambu"
)
annotations <- prepareAnnotations(x = gtf.file)

# run bambu
test.bam <- system.file("extdata", 
    "SGNex_A549_directRNA_replicate5_run1_chr9_1_1000000.bam", 
    package = "bambu")
fa.file <- system.file("extdata", 
    "Homo_sapiens.GRCh38.dna_sm.primary_assembly_chr9_1_1000000.fa", 
    package = "bambu")
se <- bambu(reads = test.bam, annotations = annotations, 
    genome = fa.file, discovery = TRUE, quant = TRUE)
}
\seealso{
[bambu()] for transcript discovery and quantification from long read RNA-Seq.
}
