% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indel_functions.R
\name{create_indel_mut_cat_from_df}
\alias{create_indel_mut_cat_from_df}
\title{Create a Mutational catalog from a data frame}
\usage{
create_indel_mut_cat_from_df(in_df, in_signatures_df)
}
\arguments{
\item{in_df}{A data frame constucted from a vcf-like file of a whole cohort
or single-sample. The first coloums are those of a standart vcf file,
followed by an arbitrary number of customs or used defined columns. One if
these can carry a PID (patient or sample identefyier) and the subgroup
information. Additionaly to consuct the the mutational catalog each variant
needs to be characterize into one of the 83 INDEL feature classes, which
can be perfomed with \code{\link[YAPSA]{attribution_of_indels}}}

\item{in_signatures_df}{A numeric data frame \code{W} with \code{n} rows and
\code{l} columns, \code{n} being the number of features and \code{l} being
the number of signatures.Data frame containing INDEL signatures which
should be used to create the mutational cataolog \code{V}.}
}
\value{
A count dataframe, the mutational catalog \code{V} with rownames
  indicating the INDELs and colnames having the PIDs
}
\description{
This function creates a mutational catalog from a data frame. It requires the
returend data frame optainted with
\code{\link[YAPSA]{attribution_of_indels}}.
}
\examples{
data(GenomeOfNl_raw)
data(sigs_pcawg)
GenomeOfNl_context <- attribute_sequence_contex_indel(in_dat =
 head(GenomeOfNl_raw))
GenomeOfNl_classified <- attribution_of_indels(GenomeOfNl_context)
GenomeOfNl_mut_cat <- create_indel_mut_cat_from_df(GenomeOfNl_classified,
 in_signatures_df=PCAWG_SP_ID_sigs_df)

}
