% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_printNode.R
\name{printNode}
\alias{printNode}
\title{To print out the node labels}
\usage{
printNode(tree, type = c("leaf", "internal", "all"))
}
\arguments{
\item{tree}{A phylo object.}

\item{type}{A character value choose from \code{leaf}, \code{all}, and
\code{internal}. If \code{leaf}, the output is a data frame including only
leaf nodes; if \code{internal}, the output is a data frame including only
internal nodes; if \code{all}, the output is a data frame including all
nodes.}
}
\value{
a data frame
}
\description{
\code{nodeLabel} is to print out the node labels of a \code{phylo} tree.
}
\examples{
data(tinyTree)
library(ggtree)

# PLOT tree
# The node labels are in orange texts and the node numbers are in blue
ggtree(tinyTree,branch.length = 'none')+
    geom_text2(aes(label = label), color = "darkorange",
           hjust = -0.1, vjust = -0.7) +
    geom_text2(aes(label = node), color = "darkblue",
               hjust = -0.5, vjust = 0.7)

(pn1 <- printNode(tinyTree, type = "leaf"))
(pn2 <- printNode(tinyTree, type = "internal"))
(pn3 <- printNode(tinyTree, type = "all"))

}
\author{
Ruizhu HUANG
}
