% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aboutLoop.R
\name{detectLoop}
\alias{detectLoop}
\title{Detect loops 
\code{detectLoop} detects loops}
\usage{
detectLoop(tax_tab)
}
\arguments{
\item{tax_tab}{a data frame where columns store hierarchical levels. The
columns from the left to the right correspond nodes from the root to the
leaf.}
}
\value{
a data frame
}
\description{
Detect loops 
\code{detectLoop} detects loops
}
\examples{

df <- data.frame(A = rep("a", 8),
                 B = rep (c("b1", "b2", "b3", "b4"), each = 2),
                 C = paste0("c", c(1, 2, 2, 3:7)),
                 D = paste0("d", 1:8))
 
# The result means that a loop is caused by 'b1' and 'b2' in column 'B' and
# 'c2' in column 'C' (a-b1-c2; a-b2-c2)
detectLoop(tax_tab = df)

df <- data.frame(R1 = rep("A", 6),
                     R2 = c("B1", rep("B2", 4), "B3"),
                     R3 = c("C1", "C2", "C3", NA, NA, NA),
                     R4 = c("D1", "D2", "D3", NA, NA, NA),
                     R5 = paste0("E", 1:6))
detectLoop(tax_tab = df)

df <- data.frame(R1 = rep("A", 7),
                     R2 = c("B1", rep("B2", 4), "B3", "B3"),
                     R3 = c("C1", "C2", "C3", "", "", "", ""),
                     R4 = c("D1", "D2", "D3", "", "", "", ""),
                     R5 = paste0("E", 1:7))
detectLoop(tax_tab = df)

df <- data.frame(R1 = rep("A", 7),
                     R2 = c("B1", rep("B2", 4), "B3", "B3"),
                     R3 = c("C1", "C2", "C3", NA, NA, NA, NA),
                     R4 = c("D1", "D2", "D3", NA, NA, NA, NA),
                     R5 = paste0("E", 1:7))
detectLoop(tax_tab = df) 
}
\author{
Ruizhu Huang
}
