% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClass.R
\docType{class}
\name{TreeSummarizedExperiment-class}
\alias{TreeSummarizedExperiment-class}
\title{An S4 class TreeSummarizedExperiment}
\description{
The class \strong{TreeSummarizedExperiment} is an extension class of standard
\code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}} class. It has
four more slots that are not in
\code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}} class:
\code{rowTree}, \code{rowLinks} \code{colTree} and \code{colLinks}. The
hierarchical information of rows (columns) is stored in \code{rowTree}
(\code{colTree}) and the link between the rows (columns) of \code{assays}
tables and nodes of the tree is given in \code{rowLinks} (\code{colLinks}).
}
\details{
The class \strong{TreeSummarizedExperiment} is designed to store
  rectangular data for entities (e.g., microbes or cell types)
  (\code{assays}), information about the hiearchical structure
  (\code{rowTree} on rows; \code{colTree} on columns), and the mapping
  information between the tree nodes and the rows or the columns of the
  rectangular data. Users could provide the hiearchical structure of the
  rows, columns or both) of the \code{assays} tables, and the link data will
  be automatically generated in \code{rowLinks}, \code{colData} or both,
  respectively. It's required that the object in \code{rowLinks} or
  \code{colLinks} has the \code{LinkDataFrame} class. Please see the page
  \code{\link{LinkDataFrame}} for more details.
}
\section{Slots}{

\describe{
\item{\code{rowTree}}{A phylo object or NULL. It gives information about the
hiearchical structure of rows of \code{assays} tables.}

\item{\code{colTree}}{A phylo object or NULL. It gives information about the
hiearchical structure of columns of \code{assays} tables.}

\item{\code{rowLinks}}{A LinkDataFrame. It gives information about the link between
the nodes of the \code{rowTree} and the rows of \code{assays} tables.}

\item{\code{colLinks}}{A LinkDataFrame. It gives information about the link between
the nodes of the \code{colTree} and the columns of \code{assays} tables.}

\item{\code{referenceSeq}}{A \code{DNAStringSet}/\code{DNAStringSetList} object or
some object coercible to a \code{DNAStringSet}/\code{DNAStringSetList}
object. See \code{\link[Biostrings:XStringSet-class]{DNAStringSet}} for
more details.}

\item{\code{...}}{Other slots from
\code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}}}
}}

\section{Constructor}{

See \code{\link{TreeSummarizedExperiment-constructor}} for constructor
functions.
}

\section{Accessor}{

See \code{\link{TreeSummarizedExperiment-accessor}} for accessor functions.
}

\seealso{
\code{\link{TreeSummarizedExperiment}}
  \code{\link{TreeSummarizedExperiment-accessor}}
  \code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}}
}
