% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mz-delta-functions.R
\name{plotMzDelta}
\alias{plotMzDelta}
\alias{computeMzDeltas}
\title{MZ delta Quality Control}
\usage{
computeMzDeltas(
  object,
  percentage = 0.2,
  mzRange = c(40, 200),
  BPPARAM = BiocParallel::bpparam()
)

plotMzDelta(x, aaLabels = TRUE)
}
\arguments{
\item{object}{An instance of class \code{Spectra()}.}

\item{percentage}{\code{numeric(1)} between 0 and 1 indicating the
percentage of the most intense peaks in each MS2 spectrum to
include in the calculation. Default is 0.2.}

\item{mzRange}{\code{numeric(2)} with the upper and lower M/Z to be used to
the MZ deltas. Default is \code{c(40, 200)}.}

\item{BPPARAM}{An optional \code{BiocParallelParam} instance determining
the parallel back-end to be used during evaluation. Default is
to use \code{BiocParallel::bpparam()}. See \code{?BiocParallel::bpparam}
for details.}

\item{x}{A list of M/Z delta values, as returned by
\code{computeMzDeltas()}.}

\item{aaLabels}{\code{logical(1)} defining whether the amino acids
should be labelled on the histogram. Default is \code{TRUE}.}
}
\value{
\code{computeMzDeltas()} returns a \code{list} of numeric
vectors. \code{plotMzDelta()} is used to visualise of M/Z delta
distributions.
}
\description{
The M/Z delta plot illustrates the suitability of MS2 spectra for
identification by plotting the M/Z differences of the most intense
peaks. The resulting histogram should optimally show modes at
amino acid residu masses. The plots have been described in Foster
et al. 2011.

Only a certain percentage of most intense MS2 peaks are taken into
account to use the most significant signal. Default value is 20\%
(see \code{percentage} argument). The difference between peaks is then
computed for all individual spectra and their distribution is
plotted as a histogram. Delta M/Z between 40 and 200 are plotted
by default, to encompass the residue masses of all amino acids and
several common contaminants, although this can be changes with the
\code{mzRange} argument.

In addition to the processing described above, isobaric reporter
tag peaks and the precursor peak can also be removed from the MS2
spectrum, to avoid interence with the fragment peaks.

Note that figures in Foster et al. 2011 have been produced and
optimised for centroided data. While running the function on
profile mode is likely fine, it is recommended to use centroided
data.

A \code{ggplot2} based function called \code{ggMzDeltaPlot()} to visualise
the M/Z delta distributions is available at
\url{https://gist.github.com/lgatto/c72b1ff5a4116118dbb34d9d2bc3470a}.
}
\examples{

library(msdata)
f <- proteomics(pattern = "TMT.+20141210.mzML.gz", full.names = TRUE)
sp <- Spectra(f)

d <- computeMzDeltas(sp[1:1000])
plotMzDelta(d)
}
\references{
Foster JM, Degroeve S, Gatto L, Visser M, Wang R, Griss J, et al. A
posteriori quality control for the curation and reuse of public
proteomics data. Proteomics. 2011;11:
2182-2194. http://dx.doi.org/10.1002/pmic.201000602
}
\author{
Laurent Gatto with contributions (to MSnbase) of
Guangchuang Yu.
}
