% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readCosMX}
\alias{readCosMX}
\title{Read CosMX data into SFE}
\usage{
readCosMX(
  data_dir,
  z = "all",
  sample_id = "sample01",
  min_area = NULL,
  add_molecules = FALSE,
  split_cell_comps = FALSE,
  BPPARAM = SerialParam(),
  file_out = file.path(data_dir, "tx_spots.parquet"),
  z_option = c("3d", "split")
)
}
\arguments{
\item{data_dir}{Top level output directory.}

\item{z}{Integer z index or "all" to indicate which z-planes to read for the
transcript spots.}

\item{sample_id}{A \code{character} sample identifier, which matches the
\code{sample_id} in \code{\link[SpatialExperiment]{imgData}}. The \code{sample_id} will also
be stored in a new column in \code{\link[SpatialExperiment]{colData}}, if not already present.
Default = \code{sample01}.}

\item{min_area}{Minimum cell area in square microns or pixel units (eg for CosMX).
Anything smaller will be considered artifact or debris and removed. 
Default to `NULL`, ie no filtering of polygons.}

\item{add_molecules}{Logical, whether to add transcripts coordinates to an
object.}

\item{split_cell_comps}{Logical, whether to split transcript spot geometries
by cell compartment. Only relevant when `add_molecules = TRUE`.}

\item{BPPARAM}{A \code{\link[BiocParallel]{BiocParallelParam}} object specifying parallel
  processing backend and number of threads to use for parallelizable tasks:
  \enumerate{ \item To load cell segmentation from HDF5 files from different
  fields of view (FOVs) with multiple cores. A progress bar can be configured
  in the \code{\link[BiocParallel]{BiocParallelParam}} object. When there are numerous
  FOVs, reading in the geometries can be time consuming, so we recommend
  using a server and larger number of threads. This argument is not used if
  \code{use_cellpose = TRUE} and the parquet file is present.

  \item To get the largest piece and see if it's larger than \code{min_area}
  when there are multiple pieces in the cell segmentation for one cell.}}

\item{file_out}{Name of file to save the geometry or raster to disk.
Especially when the geometries are so large that it's unwieldy to load
everything into memory. If this file (or directory for multiple files)
already exists, then the existing file(s) will be read, skipping the
processing. When writing the file, extensions supplied are ignored and
extensions are determined based on `dest`.}

\item{z_option}{What to do with z coordinates. "3d" is to construct 3D
geometries. "split" is to create a separate 2D geometry for each z-plane so
geometric operations are fully supported but some data wrangling is
required to perform 3D analyses. When the z coordinates are not integers,
3D geometries will always be constructed since there are no z-planes to
speak of. This argument does not apply when `spatialCoordsNames` has length
2.}
}
\value{
An SFE object. Cell polygons are written to
  `cell_boundaries_sf.parquet` in `data_dir`. If reading transcript spots
  (`add_molecules = TRUE`), then the reformatted transcript spots are saved
  to file specified in the `file_out` argument, which is by default
  `tx_spots.parquet` in the same directory as the rest of the data.
}
\description{
This function reads the standard CosMX output into an SFE object, as in
"Basic Data Files" on the Nanostring website. For new version of CosMX, these
files are the flat files in the AtoMX output.
}
\examples{
fp <- tempfile()
dir_use <- SFEData::CosMXOutput(file_path = fp)
sfe <- readCosMX(dir_use, z = "all", add_molecules = TRUE)
# Clean up
unlink(dir_use, recursive = TRUE)
}
\concept{Read data into SFE}
