% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue_boundary.R
\name{getTissueBoundaryConcave}
\alias{getTissueBoundaryConcave}
\title{Get tissue boundary from concave hull of cell geometries}
\usage{
getTissueBoundaryConcave(
  sfe,
  sample_id = NULL,
  colGeometryName = 1L,
  ratio = 0.01,
  allow_holes = TRUE
)
}
\arguments{
\item{sfe}{An SFE object with images}

\item{sample_id}{Sample id(s) whose tissue boundaries are to be found.}

\item{colGeometryName}{Name of the \code{colGeometry} to use to infer the
concave hull.}

\item{ratio}{numeric; fraction convex: 1 returns the convex hulls, 0 maximally concave hulls}

\item{allow_holes}{logical; if \code{TRUE}, the resulting concave hull may have holes}
}
\value{
A \code{sf} data frame with columns \code{sample_id} and
  \code{geometry}.
}
\description{
The concave hull will be a smoothed outline, and the smoothness can be
adjusted with the \code{ratio} parameter. Run \code{\link{findDebrisCells}}
to remove small bits outside the main piece tissue before running this
function.
}
