% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{getPixelSize}
\alias{getPixelSize}
\title{Get physical size of pixels}
\usage{
getPixelSize(file, resolution = 1L)
}
\arguments{
\item{file}{Path to an OME-TIFF file.}

\item{resolution}{Which resolution to query; 1 means the highest resolution.
The pixels will be larger for the lower resolutions.}
}
\value{
Numeric vector of length 2 of pixel size in x and y. Usually they're
the same.
}
\description{
This function gets physical size of pixels in each resolution of a OME-TIFF
pyramid in \code{\link{BioFormatsImage}}.
}
\examples{
library(SFEData)
fp <- tempfile()
dir_use <- XeniumOutput("v1", file_path = fp)
# RBioFormats null pointer error
try(getPixelSize(file.path(dir_use, "morphology_focus.ome.tif")))
getPixelSize(file.path(dir_use, "morphology_focus.ome.tif"))
unlink(dir_use, recursive = TRUE)
}
\concept{Utilities}
