% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{SpatialDecon-package}
\alias{SpatialDecon-package}
\title{SpatialDecon: A package for estimating mixed cell type abundance in the regions of 
spatially-resolved gene expression studies}
\description{
The SpatialDecon package estimates mixed cell type abundance in the regions
of spatially-resolved gene
expression studies, using the method of Danaher & Kim (2020), "Advances in
 mixed cell deconvolution enable
quantification of cell types in spatially-resolved gene expression data."
It is also appropriate to apply to bulk gene expression data.
}
\section{functions}{

Functions to help set up deconvolution:
\itemize{
 \item derive_GeoMx_background Estimates the background levels from GeoMx
 experiments
 \item collapseCellTypes reformats deconvolution results to merge
 closely-related cell types
 \item download_profile_matrix Downloads a cell profile matrix.
 \item safeTME: a data object, a matrix of immune cell profiles for use in
  tumor-immune deconvolution.
}
Deconvolution functions:
\itemize{
 \item spatialdecon runs the core deconvolution function
 \item reverseDecon runs a transposed/reverse deconvolution problem, fitting
 the data as a function of cell abundance estimates.
  Used to measure genes' dependency on cell mixing and to calculate gene
   residuals from cell mixing.
}
Plotting functions:
\itemize{
 \item florets Plot cell abundance on a specified x-y space, with each point
  a cockscomb plot showing the cell abundances of that region/sample.
 \item TIL_barplot Plot abundances of tumor infiltrating lymphocytes (TILs)
  estimated from the safeTME cell profile matrix
}
}

\examples{
data(mini_geomx_dataset)
data(safeTME)
data(safeTME.matches)
# estimate background:
mini_geomx_dataset$bg <- derive_GeoMx_background(
  norm = mini_geomx_dataset$normalized,
  probepool = rep(1, nrow(mini_geomx_dataset$normalized)),
  negnames = "NegProbe"
)
# run basic decon:
res0 <- spatialdecon(
  norm = mini_geomx_dataset$normalized,
  bg = mini_geomx_dataset$bg,
  X = safeTME
)
# run decon with bells and whistles:
res <- spatialdecon(
  norm = mini_geomx_dataset$normalized,
  bg = mini_geomx_dataset$bg,
  X = safeTME,
  cellmerges = safeTME.matches,
  cell_counts = mini_geomx_dataset$annot$nuclei,
  is_pure_tumor = mini_geomx_dataset$annot$AOI.name == "Tumor"
)
}
