% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXenium.R
\name{readXeniumSPE}
\alias{readXeniumSPE}
\title{Load data from a 10x Genomics Xenium experiment}
\usage{
readXeniumSPE(
  dirName,
  sampleName = "sample01",
  type = c("HDF5", "sparse"),
  coordNames = c("x_centroid", "y_centroid"),
  boundariesType = c("parquet", "csv"),
  computeMissingMetrics = TRUE,
  keepPolygons = FALSE,
  countsFilePattern = "cell_feature_matrix",
  metadataFPattern = "cells.csv.gz",
  polygonsFPattern = "cell_boundaries",
  polygonsCol = "polygons",
  txPattern = "transcripts",
  addFOVs = FALSE
)
}
\arguments{
\item{dirName}{`character(1)`
Path to a Xenium Output Bundle directory.}

\item{sampleName}{`character(1)`
Sample identifier to assign to `sample_id`. Default: `"sample01"`.}

\item{type}{`character(1)`
One of `"HDF5"` or `"sparse"`; method to read the feature matrix.}

\item{coordNames}{`character(2)`
Names of X/Y spatial coordinate columns. Default:
`c("x_centroid", "y_centroid")`.}

\item{boundariesType}{`character(1)`
One of `"parquet"` or `"csv"`; format of the polygon file.}

\item{computeMissingMetrics}{`logical(1)`
If `TRUE`, compute area and aspect‐ratio from boundary polygons.}

\item{keepPolygons}{`logical(1)`
If `TRUE`, append raw polygon geometries to `colData`.}

\item{countsFilePattern}{`character(1)`
Pattern to locate the feature matrix file. Default:
`"cell_feature_matrix"`.}

\item{metadataFPattern}{`character(1)`
Pattern to locate the cell metadata file. Default: `"cells"`.}

\item{polygonsFPattern}{`character(1)`
Pattern to locate the cell boundaries file. Default:
`"cell_boundaries"`.}

\item{polygonsCol}{`character(1)`
Name of the polygons column to add to `colData`. Default:
`"polygons"`.}

\item{txPattern}{`character(1)`
Pattern (base filename, without extension) to locate the transcript file
(usually a `.parquet` file) from which to extract Field-Of-View (FOV)
information for each cell. Default: `"transcripts"`.}

\item{addFOVs}{`logical(1)`
If `TRUE`, extract Field-Of-View (FOV) information from the transcript file
(as located by `txPattern`) and append it to cell metadata (`colData`).
Default: `FALSE`.}
}
\value{
A [`SpatialExperiment`] object with assays, `colData`, spatial
  coordinates, and `metadata$polygons` & `metadata$technology`.
}
\description{
Creates a [`SpatialExperiment`] from an unzipped Xenium Output Bundle
directory containing spatial gene expression data.
}
\details{
readXeniumSPE


Expects the unzipped bundle to contain an `outs/` folder with:
- `cell_feature_matrix.h5` or `cell_feature_matrix/`
- `cells.csv.gz`
}
\examples{
xepath <- system.file(
  "extdata", "Xenium_small", package = "SpaceTrooper"
)
(spe <- readXeniumSPE(
  dirName = xepath,
  keepPolygons = TRUE
))
}
\author{
Dario Righelli, Benedetta Banzi
}
