% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_MSstats_OpenSWATH.R
\name{transform_MSstats_OpenSWATH}
\alias{transform_MSstats_OpenSWATH}
\title{Transforms column names to OpenSWATH column names}
\usage{
transform_MSstats_OpenSWATH(data)
}
\arguments{
\item{data}{A data frame containing the SWATH data in the MSstats format}
}
\value{
The data frame in the appropriate format.
}
\description{
This functions transforms the column names from a data frame in MSstats
format to a data frame with column names used by the OpenSWATH output. The
original table needs to contain at least the 10 columns defined by MSstats:
ProteinName, PeptideSequence, PrecursorCharge, Fragmentation, ProductCharge,
IsotopeLabelType, Condition, BioReplicate, Run, Intensity.)
}
\examples{
 data("MSstats_data", package="SWATH2stats")
 transformed <- transform_MSstats_OpenSWATH(MSstats_data)
}
\references{
Choi M, Chang CY, Clough T, Broudy D, Killeen T, MacLean B, Vitek
  O. MSstats: an R package for statistical analysis of quantitative mass
  spectrometry-based proteomic experiments.Bioinformatics. 2014 Sep
  1;30(17):2524-6. doi: 10.1093/bioinformatics/btu305.
}
\author{
Peter Blattmann
}
