% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-svg.R
\name{runDetectSVG}
\alias{runDetectSVG}
\alias{runDetectSVG,SingleCellExperiment-method}
\alias{runDetectSVG,SingleCellExperiment}
\alias{runDetectSVG,SVPExperiment-method}
\alias{runDetectSVG,SVPExperiment}
\title{Detecting the spatially or single cell variable features with Moran's I or Geary's C}
\usage{
runDetectSVG(
  data,
  assay.type = "logcounts",
  method = c("moransi", "gearysc", "getisord"),
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  sample_id = "all",
  reduction.used = NULL,
  group.by = NULL,
  permutation = NULL,
  p.adjust.method = "BH",
  random.seed = 1024,
  verbose = TRUE,
  action = c("add", "only", "get"),
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)

\S4method{runDetectSVG}{SingleCellExperiment}(
  data,
  assay.type = "logcounts",
  method = c("moransi", "gearysc", "getisord"),
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  sample_id = "all",
  reduction.used = NULL,
  group.by = NULL,
  permutation = NULL,
  p.adjust.method = "BH",
  random.seed = 1024,
  verbose = TRUE,
  action = c("add", "only", "get"),
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)

\S4method{runDetectSVG}{SVPExperiment}(
  data,
  assay.type = "logcounts",
  method = c("moransi", "gearysc", "getisord"),
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  sample_id = "all",
  reduction.used = NULL,
  group.by = NULL,
  permutation = NULL,
  p.adjust.method = "BH",
  random.seed = 1024,
  verbose = TRUE,
  action = c("add", "only", "get"),
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  ...
)
}
\arguments{
\item{data}{a \linkS4class{SingleCellExperiment} object with contains \code{UMAP} or \code{TSNE},
or a \linkS4class{SpatialExperiment} object, or a \linkS4class{SVPExperiment} object with specified
\code{gsvaexp} argument.}

\item{assay.type}{which expressed data to be pulled to run, default is \code{logcounts}.}

\item{method}{character the method of spatial autocorrelation using a spatial weights to detect spatial
variable features, one of \code{'moransi'}, \code{"gearysc"} or \code{"getisord"}, default is \code{'moransi'}.}

\item{weight}{object, which can be \code{nb}, \code{listw} or \code{Graph} object, default is NULL,
meaning the spatial neighbours weights will be calculated using the \code{weight.method}.
if the \code{data} contains multiple samples, and the \code{sample_id} is specified, it should be
provided as a list object with names (using \code{sample_id}).}

\item{weight.method}{character the method to build the spatial neighbours weights, default
is \code{voronoi} (Voronoi tessellation). Other method, which requires coord matrix as input and returns
\code{nb}, \code{listw} or \code{Graph} object, also is available, such as \code{"knearneigh"},
\code{'dnearneigh'}, \code{"gabrielneigh"}, \code{"relativeneigh"}, which are from \code{spdep} package.
default is \code{knn}, if it is \code{"none"}, meaning the distance weight of each spot is used to
the weight.}

\item{sample_id}{character the sample(s) in the \linkS4class{SpatialExperiment} object whose cells/spots to use.
Can be \code{all} to compute metric for all samples; the metric is computed separately for each sample.
default is \code{"all"}.}

\item{reduction.used}{character used as spatial coordinates to detect SVG, default is \code{UMAP},
if \code{data} has \code{spatialCoords}, which will be used as spatial coordinates.}

\item{group.by}{character a specified category column names (for example the cluster column name) of
\code{colData(data)}. Or a vector of length equal to \code{ncol(data)}, specifying the group to which each cell
is assigned. If it was specified, the adjacency weighted matrix will be built based on the principle that
spots or cells in the same category are adjacent, default is NULL.}

\item{permutation}{integer the number to permutation test for the calculation of Moran's I, default
is NULL. We do not recommend using this parameter, as the permutation test is too slow.}

\item{p.adjust.method}{character the method to adjust the pvalue of the result, default is \code{BH}.}

\item{random.seed}{numeric random seed number to repeatability, default is 1024.}

\item{verbose}{logical whether print the intermediate message when running the program, default is TRUE.}

\item{action}{character control the type of output, if \code{action='add'}, the result of identification
will add the original object, if \code{action = 'get'}, the result will return a \linkS4class{SimpleList},
if \code{action = 'only'}, the result will return a \linkS4class{DataFrame} by merging the result of all
sample, default is \code{add}.}

\item{gsvaexp}{which gene set variation experiment will be pulled to run, this only work when \code{data} is a
\linkS4class{SVPExperiment}, default is NULL.}

\item{gsvaexp.assay.type}{which assay data in the specified \code{gsvaexp} will be used to run, default is NULL.}

\item{...}{additional parameters}
}
\value{
a \linkS4class{SVPExperiment} or a \linkS4class{SingleCellExperiment}, see \code{action} parameter details.
}
\description{
This function use Moran's I, Geary's C or global G test to detect the signal genes in
a low-dimensional space (\code{UMAP} or \code{TSNE} for single cell omics data) or
a physical space (for spatial omics data).
}
\examples{
# This example dataset is extracted from the
# result of runSGSA with gsvaExp(svpe).
data(hpda_spe_cell_dec)

# using Moran's I test
######################
hpda_spe_cell_dec <-
    hpda_spe_cell_dec |>
    runDetectSVG(
      assay.type = 'affi.score',
      method = 'moransi'
    )
# The result also is saved in the svDfs in the SVPExample object
# which can be extrated with svDf 
svDfs(hpda_spe_cell_dec)

hpda_spe_cell_dec |> svDf("sv.moransi") |> data.frame() |> dplyr::arrange(rank)

# using Geary's C test 
#######################
hpda_spe_cell_dec <-
    hpda_spe_cell_dec |>
    runDetectSVG(assay.type ='affi.score', method = 'gearysc')

svDfs(hpda_spe_cell_dec)

hpda_spe_cell_dec |> svDf("sv.gearysc") |> data.frame() |> dplyr::arrange(rank)

# using Global G test (Getis-Ord)
#################################
hpda_spe_cell_dec <- hpda_spe_cell_dec |>
    runDetectSVG(assay.type = 1, method = 'getisord')

svDfs(hpda_spe_cell_dec)

hpda_spe_cell_dec |> svDf(3) |> data.frame() |> dplyr::arrange(rank)
}
\references{
\enumerate{
\item P. A. P. Moran, The Interpretation of Statistical Maps, Journal of the Royal Statistical
Society: Series B (Methodological), Volume 10, Issue 2, July 1948, Pages 243–251,
https://doi.org/10.1111/j.2517-6161.1948.tb00012.x
\item R. C. Geary, The Contiguity Ratio and Statistical Mapping, Journal of the Royal Statistical
Society Series D: The Statistician, Volume 5, Issue 3, November 1954, Pages 115–141,
https://doi.org/10.2307/2986645
\item Cli AD, Ord JK (1981) Spatial processes: models & applications. Pion Limited, London
\item Bivand, R.S., Wong, D.W.S. Comparing implementations of global and local indicators of spatial
association. TEST 27, 716–748 (2018). https://doi.org/10.1007/s11749-018-0599-x
}
}
\seealso{
\code{\link{runLISA}} to explore the hotspot for specified features in the spatial space.
}
\author{
Shuangbin Xu
}
