% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-detect.marker.R
\name{runDetectMarker}
\alias{runDetectMarker}
\alias{runDetectMarker,SingleCellExperiment-method}
\alias{runDetectMarker,SingleCellExperiment}
\title{Detecting the specific cell features with nearest distance of cells in MCA space}
\usage{
runDetectMarker(
  data,
  group.by,
  aggregate.group = TRUE,
  reduction = "MCA",
  dims = 30,
  ntop = 200,
  present.prop.in.group = 0.1,
  present.prop.in.sample = 0.2,
  BPPARAM = SerialParam(),
  ...
)

\S4method{runDetectMarker}{SingleCellExperiment}(
  data,
  group.by,
  aggregate.group = TRUE,
  reduction = "MCA",
  dims = 30,
  ntop = 200,
  present.prop.in.group = 0.1,
  present.prop.in.sample = 0.2,
  BPPARAM = SerialParam(),
  ...
)
}
\arguments{
\item{data}{SingleCellExperiment object}

\item{group.by}{the column name of cell annotation. Or a vector of length equal to
\code{ncol(data)}, specifying the group to which each cell is assigned. It is required.}

\item{aggregate.group}{logical whether calculate the center cluster of each group of cell according
to the \code{group.by}, then find the nearest features of the center cluster, default TRUE. If
FALSE, meaning the nearest features to each cell are detected firstly.}

\item{reduction}{character which reduction space, default is \code{'MCA'}.}

\item{dims}{integer the number of components to defined the nearest distance.}

\item{ntop}{integer the top number of nearest or furthest (\code{type = 'negative'}) features,
default is 200.}

\item{present.prop.in.group}{numeric the appearance proportion of groups which have the marker
default is .1, smaller value represent the marker will have higher specificity, but the number of
marker for each group might also decrease, the minimum value is \code{1/length(unique(data[[group.by]]))}.}

\item{present.prop.in.sample}{numeric the appearance proportion of samples which have the marker in
the corresponding group by specific \code{group.by}, default is 0.2.}

\item{BPPARAM}{A BiocParallelParam object specifying whether perform the analysis in parallel using
\code{BiocParallel} default is \code{SerialParam()}, meaning no parallel.
You can use \code{BiocParallel::MulticoreParam(workers=4, progressbar=TRUE)} to parallel it,
the \code{workers} of \code{MulticoreParam} is the number of cores used, see also
\code{\link[BiocParallel]{MulticoreParam}}. default is \code{SerialParam()}.}

\item{...}{additional parameters.}
}
\value{
a list, which contains features and named with clusters of \code{group.by}.
}
\description{
Detecting the specific cell features with nearest distance of cells in MCA space
}
\examples{
# The example data (small.sce) is generated through simulation and has no actual meaning.
set.seed(123)
example(runMCA, echo = FALSE)
small.sce |> runDetectMarker(group.by = 'Cell_Cycle', ntop = 20, 
              present.prop.in.sample = .2)
# group.by, a vector of length equal to ncol(small.sce)
small.sce |> runDetectMarker(
               group.by = small.sce$Cell_Cycle, 
               ntop = 20,
               present.prop.in.sample = .2
             )
}
