% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor-utils.R
\name{fast_cor}
\alias{fast_cor}
\title{Calculation of correlations and associated p-values}
\usage{
fast_cor(
  x,
  y = NULL,
  combine = FALSE,
  method = c("pearson", "spearman", "bicorr"),
  alternative = c("two.sided", "less", "greater"),
  add.pvalue = FALSE
)
}
\arguments{
\item{x}{sparse Matrix which rows are the features and columns are the samples.}

\item{y}{sparse Matrix which has the same column length of \code{x},
default is NULL.}

\item{combine}{logical whether combine the correlation of \code{x} and \code{y}
if \code{y} is provided, default is FALSE.}

\item{method}{a character string indicating which correlation coefficient,
One of \code{"pearson"} (default), \code{"spearman"} and \code{"bicorr"}.}

\item{alternative}{indicates the alternative hypothesis and must be one of
the initial letter \code{"two.sided"}, \code{"less"} and \code{"greater"}.
\code{"greater"} corresponds to positive association, \code{"less"} to negative
association, default is \code{"two.sided"}.}

\item{add.pvalue}{logical whether calculate the pvalue of correlation using t
test, default is FALSE.}
}
\value{
a list containing the matrix of correlation and matrix of pvalue (if
\code{add.pvalue} is FALSE (default), the matrix of pvalue will be NULL).
}
\description{
Calculation of correlations and associated p-values
}
\examples{
set.seed(123)
x <- matrix(rnorm(500), ncol=10)
rownames(x) <- paste0('row', seq(nrow(x)))
colnames(x) <- paste0('col', seq(ncol(x)))
x <- Matrix::Matrix(x, sparse = TRUE)
x1 <- x[seq(10),]
x2 <- x[seq(11, 50),]
res <- fast_cor(x = x1, y = x2, combine = FALSE)
res$r |> dim()
res2 <- fast_cor(x = x1, y = x2, combine = TRUE)
res2$r |> dim()
}
