% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{SVPExperiment}
\alias{SVPExperiment}
\alias{coerce,SingleCellExperiment,SVPExperiment-method}
\alias{SVPExperiment-class}
\title{The SVPExperiment class}
\usage{
SVPExperiment(..., gsvaExps = list())
}
\arguments{
\item{...}{passed to the \code{\link{SingleCellExperiment}} constructor to
fill the slots of the base class.}

\item{gsvaExps}{list containing \linkS4class{SingleCellExperiment} object,
each of which should have the same number of columns as the output
\linkS4class{SVPExperiment} object.}
}
\value{
a \linkS4class{SVPExperiment} object
}
\description{
The SVPExperiment class
}
\examples{
library(SingleCellExperiment) |> suppressPackageStartupMessages()
ncells <- 100
u <- matrix(rpois(20000, 5), ncol=ncells)
v <- log2(u + 1)
pca <- matrix(runif(ncells*5), ncells)
tsne <- matrix(rnorm(ncells*2), ncells)

svpe <- SVPExperiment(assays=list(counts=u, logcounts=v),
    reducedDims=SimpleList(PCA=pca, tSNE=tsne))
svpe

## coercion from SingleCellExperiment
sce <- SingleCellExperiment(assays=list(counts=u, logcounts=v),
reducedDims=SimpleList(PCA=pca, tSNE=tsne))
svpe <- as(sce, 'SVPExperiment')
svpe
}
\author{
Shuangbin Xu
}
