% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_structure.R
\name{define_structure}
\alias{define_structure}
\title{define_structure}
\usage{
define_structure(
  spe_object,
  cell_types_of_interest,
  feature_colname = "Cell.Type",
  n_margin_layers = 5,
  margin_dist = NULL
)
}
\arguments{
\item{spe_object}{SpatialExperiment object that contains information of
tumour bordering cells and cell distances to border (`colData()` has
`Region` and `Distance.To.Border` columns).}

\item{cell_types_of_interest}{String Vector of the names of the particular
types of cells.}

\item{feature_colname}{String Specifying the column that contains the names
of the immune cells.}

\item{n_margin_layers}{Integer. The number of layers of cells that compose
the internal/external margins. Default is 5.}

\item{margin_dist}{Numeric. The width of the internal/external margins. 
Default is NULL. Only use when `n_margin_layers` is NULL.}
}
\value{
A new spe object is returned. Under the `Region` column, there will
  be potential categories including `Border` - the bordering cells,
  `Infiltrated.CoI` - cells of interest that present inside of the tissue
  regions, `Inside` - cells within the regiona excluding the
  `Infiltrated.CoI` cells and the cells at internal margin, `Stromal.CoI` -
  cells of interest that present outside of the tissue regions, `Outside` -
  cells outside of the tissue regions excluding the `Stromal.CoI` cells,
  `Internal.margin.CoI` - cells of interest that are in the internal margin
  of the tissue regions, `Internal.margin` - cells in the internal margin of
  the tissue regions excluding the `Internal.margin.CoI` cells,
  `External.margin.CoI` - cells of interest that are in the external margin
  of the tissue regions, `External.margin` - cells in the external margin of
  the tissue regions excluding the `External.margin.CoI` cells.
}
\description{
After identifying the bordering cells of tissue regions and
  calculating the distances of each cell to the bordering cells, this
  function further identifies the cells that are located in the inside and
  outside of the identified regions, and in the internal and external
  margins. It also identifies particular types of cells that are infiltrated,
  stromal, internal margin or external margin cells.
}
\examples{
spe_border <- identify_bordering_cells(SPIAT::defined_image,
reference_cell = "Tumour", feature_colname = "Cell.Type", n_to_exclude = 10)
spe_dist <- calculate_distance_to_margin(spe_border)
spe_structure <- define_structure(spe_dist,
cell_types_of_interest = c("Immune1","Immune2","Immune3"),
feature_colname = "Cell.Type", n_margin_layers = 5)
plot_cell_categories(spe_structure, feature_colname = "Structure")
}
