% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public_data.R
\name{load_public_dataset}
\alias{load_public_dataset}
\title{load_public_dataset}
\usage{
load_public_dataset(dataset_entry, verbose = FALSE, reactome_url = NULL)
}
\arguments{
\item{dataset_entry}{The entry of the respective dataset as returned by 
the \code{\link{find_public_datasets}} function.}

\item{verbose}{If set to \code{TRUE}, status messages and a status bar are displayed.}

\item{reactome_url}{URL of the Reactome API Server. Overwrites the URL set in the 'reactome_gsa.url' option.
Specific ports can be set using the standard URL specification (for example http://your.service:1234)}
}
\value{
The loaded data as an ExpressionSet object.
}
\description{
Loads a public dataset that was found through the 
\code{\link{find_public_datasets}} function. The dataset
is returned as a Biobase ExpressionSet object.
}
\examples{
# As a first step, you need to find available datasets
available_datasets <- find_public_datasets("psoriasis tnf")

# have a quick look at the found datasets
available_datasets[, c("id", "title")]

# load the first one, use the whole row of the found datasets
# data.frame as the parameter
dataset_1 <- load_public_dataset(available_datasets[1,], verbose = TRUE)

}
