% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_result.R
\docType{class}
\name{ReactomeAnalysisResult-class}
\alias{ReactomeAnalysisResult-class}
\alias{ReactomeAnalysisResult}
\title{ReactomeAnalysisResult class}
\value{
A ReactomeAnalysisResult object.
}
\description{
A ReactomeAnalysisResult object contains the pathway analysis results of all
submitted datasets at once.
}
\details{
This class represents a result retrieved from the Reactome Analysis Service. It is returned
by \code{\link{get_reactome_analysis_result}} and its wrapper \code{\link{perform_reactome_analysis}}.
Generally, object of this class should not be created manually.
}
\section{Slots}{

\describe{
\item{\code{reactome_release}}{The Reactome version used to create this result.}

\item{\code{mappings}}{Stores the mapping results that were generated for this analysis.}

\item{\code{results}}{A named list containing the actual analysis results for every dataset
and possibly combined results as well.}

\item{\code{reactome_links}}{Links pointing to reactome results as a list.}
}}

\section{Methods}{


\bold{\code{\link{names}}}:
Retrieves the names of all datasets in the result object

\bold{\code{\link{result_types}}}:
Retrieves the available result types

\bold{\code{\link{pathways}}}:
Merges the pathway results of all analysed datasets.

\bold{\code{\link{get_result}}}:
Retrieve a specific result as data.frame

\bold{\code{\link{reactome_links}}}:
Displays / retrieves the URLs to the available visualizations in Reactome's pathway browser.

\bold{\code{\link{open_reactome}}}:
Opens the specified Reactome visualization in the system's default browser.
}

\examples{
# load an example result object
library(ReactomeGSA.data)
data(griss_melanoma_result)

# retrieve the names of all datasets in the result
names(griss_melanoma_result)

# get the combined pathway result
pathway_result <- pathways(griss_melanoma_result)

# check which result types are available
result_types(griss_melanoma_result)

# get the fold changes for the first dataset
first_dataset_name <- names(griss_melanoma_result)[1]

first_fc <- get_result(griss_melanoma_result, "fold_changes", first_dataset_name)
}
