% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_metadata.R
\name{write_zarr_attributes}
\alias{write_zarr_attributes}
\title{Read the .zattrs file associated with a Zarr array or group}
\usage{
write_zarr_attributes(zarr_path, new.zattrs = list(), overwrite = TRUE)
}
\arguments{
\item{zarr_path}{A character vector of length 1. This provides the
path to a Zarr array or group.}

\item{new.zattrs}{a list inserted to .zattrs at the \code{path}.}

\item{overwrite}{if \code{TRUE} (the default), existing .zattrs elements will be overwritten by \code{new.zattrs}.}
}
\description{
Read the .zattrs file associated with a Zarr array or group
}
\examples{
z1 <- withr::local_tempdir(fileext = ".zarr")
write_zarr_attributes(z1, list(date = "2025-01-01", author = "Jane Doe"))

}
