% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Networks.R
\name{createNetworkFromGraph}
\alias{createNetworkFromGraph}
\title{Create Network From Graph}
\usage{
createNetworkFromGraph(
  graph,
  title = "From graph",
  collection = "My GraphNEL Network Collection",
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{graph}{A GraphNEL object}

\item{title}{(char) network name}

\item{collection}{(char) network collection name}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
Network SUID
}
\description{
Creates a Cytoscape network from a Bioconductor graph.
}
\examples{
\donttest{
library(graph)
g <- makeSimpleGraph()
createNetworkFromGraph(g)
}
}
\author{
Alexander Pico, Tanja Muetze, Georgi Kolishovski, Paul Shannon
}
