% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_funcs.R
\name{split_large_pg}
\alias{split_large_pg}
\title{Split too large PGs}
\usage{
split_large_pg(adj, size_max)
}
\arguments{
\item{adj}{Adjacency matrix between peptides and PGs.}

\item{size_max}{Maximum PG size desired.}
}
\value{
New adjacency matrix between peptides and PGs.
}
\description{
Randomly splits PGs with too many peptides/precursors, while 
keeping other PGs untouched. The new PGs created all have size equal to 
size max. Hence, some peptides can be duplicated in the new PGs created.
}
\examples{
data(subbouyssie)
split.obj <- split_large_pg(subbouyssie$adj, 5)

}
