% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pirat_utils.R
\name{impute_from_blocks}
\alias{impute_from_blocks}
\title{Impute abundance table from PGs results}
\usage{
impute_from_blocks(logs.blocks, data.pep.rna, idx_blocks = NULL)
}
\arguments{
\item{logs.blocks}{List of PGs imputation results, that also contains 
related peptide/PGs adjacency matrix.}

\item{data.pep.rna}{List representing the dataset not yet imputed}

\item{idx_blocks}{Indices of PGs for which imputation results should be 
integrated}
}
\value{
The original peptide abundance table with imputed values.
}
\description{
From imputation results in each PG and the associate adjacency 
peptide/PG matrix,imputes the original abundance table.  .
}
\examples{
\donttest{
Py_impute_block_llk_reset <- function(data.pep.rna.mis, psi) { 
proc <- basilisk::basiliskStart(envPirat)

func <- basilisk::basiliskRun(proc, 
    fun = function(arg1, arg2) {
        
        imputed_pgs <- Pirat::impute_block_llk_reset(arg1, arg2)
        imputed_pgs 
    }, arg1 = data.pep.rna.mis, arg2 = psi)

basilisk::basiliskStop(proc)
func
}


data(subbouyssie)
obj <- subbouyssie
# Keep only fully observed peptides
obs2NApep <- obj$peptides_ab[ ,colSums(is.na(obj$peptides_ab)) <= 0] 
res_hyperparam <- estimate_psi_df(obs2NApep)
psi <- res_hyperparam$psi
imputed_pgs <- Py_impute_block_llk_reset(obj, psi)
impute_from_blocks(imputed_pgs, obj)
}

}
