% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTaxaGroups.R
\name{gridArrangeSharedLegend}
\alias{gridArrangeSharedLegend}
\title{Plot Multiple Graphs with Shared Legend in a Grid}
\usage{
gridArrangeSharedLegend(...,  ncol = length(list(...)), nrow = 1,
    position = c("bottom", "right"), title = NA, titleSize = 12)
}
\arguments{
\item{...}{Plots to be arranged in grid}

\item{ncol}{Number of columns in grid}

\item{nrow}{Number of rows in grid}

\item{position}{Gird position (bottom or right)}

\item{title}{Title of grid}

\item{titleSize}{Size of grid title}
}
\value{
Grid of plots with common legend
}
\description{
Plot Multiple Graphs with Shared Legend in a Grid
}
\note{
adapted from https://rdrr.io/github/PhilBoileau/CLSAR/src/R/
gridArrangeSharedLegend.R
}
\examples{
\dontrun{
data("mainLongRaw", package="PhyloProfile")
data <- mainLongRaw
inGroup <- c("ncbi9606", "ncbi10116")
varNames <- colnames(data)[c(4, 5)]
plotDf <- dataVarDistTaxGroup(data, inGroup, "101621at6656", varNames)
plotParameters <- list(
    "xSize" = 12,
    "ySize" = 12,
    "titleSize" = 15,
    "legendSize" = 12,
    "legendPosition" = "right",
    "mValue" = "mean",
    "inGroupName" = "In-group",
    "outGroupName" = "Out-group",
    "title" = "101621at6656"
)
plotVar1 <- generateSinglePlot(plotDf, plotParameters, colnames(plotDf)[1])
plotVar2 <- generateSinglePlot(plotDf, plotParameters, colnames(plotDf)[2])
g <- gridArrangeSharedLegend(
    plotVar1, plotVar2,
    position = plotParameters$legendPosition,
    title = plotParameters$title,
    size = plotParameters$titleSize
)
}
}
\author{
Phil Boileau, \email{philippe.boileau@rimuhc.ca}
}
