% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTaxonomyMatrix.R
\name{getTaxHierarchy}
\alias{getTaxHierarchy}
\title{Get taxonomy hierarchy for a list of taxon IDs}
\usage{
getTaxHierarchy(inputTaxa = NULL, currentNCBIinfo = NULL)
}
\arguments{
\item{inputTaxa}{NCBI ID list of input taxa.}

\item{currentNCBIinfo}{table/dataframe of the pre-processed NCBI taxonomy
data (/PhyloProfile/data/preProcessedTaxonomy.txt)}
}
\value{
A list of dataframs containing taxonomy hierarchy and its URL to
NCBI database for input taxon IDs
}
\description{
Get NCBI taxonomy hierarchy and URLs for an input taxon list.
}
\examples{
inputTaxa <- c("272557", "176299")
ncbiFilein <- system.file(
    "extdata", "data/preProcessedTaxonomy.txt",
    package = "PhyloProfile", mustWork = TRUE
)
currentNCBIinfo <- as.data.frame(data.table::fread(ncbiFilein))
PhyloProfile:::getTaxHierarchy(inputTaxa, currentNCBIinfo)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
