% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareTaxaGroups.R
\name{dataVarDistTaxGroup}
\alias{dataVarDistTaxGroup}
\title{Create data for variable distribution comparison plot}
\usage{
dataVarDistTaxGroup(data, inGroup, gene, variable)
}
\arguments{
\item{data}{input phylogenetic profile in long format (see ?mainLongRaw and
?createLongMatrix)}

\item{inGroup}{ID list of in-group taxa (e.g. "ncbi1234")}

\item{gene}{ID of gene that need to be plotted the distribution comparison
between in- and out-group taxa.}

\item{variable}{var1 or c(var1, var2)}
}
\value{
Dataframe containing list of values for all available variables for
the selected genes in in-group and out-group taxa (max. 3 columns).
}
\description{
Create data for plotting the distribution comparison between 2
groups of taxa for a selected gene.
}
\examples{
data("mainLongRaw", package="PhyloProfile")
data <- mainLongRaw
inGroup <- c("ncbi9606", "ncbi10116")
variable <- colnames(data)[c(4, 5)]
dataVarDistTaxGroup(data, inGroup, "101621at6656", variable)
}
\seealso{
\code{\link{createLongMatrix}}
}
\author{
Vinh Tran (tran@bio.uni-frankfurt.de)
}
