% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDomainPlot.R
\name{addFeatureColors}
\alias{addFeatureColors}
\title{Add colors for each feature/domain}
\usage{
addFeatureColors(
  seedDf = NULL,
  orthoDf = NULL,
  colorType = "all",
  colorPalette = "Paired",
  ignoreInstanceNo = FALSE
)
}
\arguments{
\item{seedDf}{Domain dataframe of seed protein (protein 1)}

\item{orthoDf}{Domain dataframe of orthologs protein (protein 2)}

\item{colorType}{Choose to color "all", "shared", "unique" features or color
by "Feature type". Default: "all"}

\item{colorPalette}{Choose between "Paired", "Set1", "Set2", "Set3",
"Accent", "Dark2" for the color pallete}

\item{ignoreInstanceNo}{Ignore number of feature instances while identifying
shared or unique features. Default: FALSE}
}
\value{
2 dataframes (seedDf and orthoDf) with an additional column for the
assigned color to each feature instance
}
\description{
Add colors to features/domains of 2 domain dataframes. Users can
choose to color only the shared features, unique features, all features
(default) or based on feature types. Default color pallete is "Paired", but
it can be changed.
}
\examples{
# get domain data
seedID <- "101621at6656"
domainFile <- system.file(
    "extdata", "domainFiles/101621at6656.domains",
    package = "PhyloProfile", mustWork = TRUE
)
domainDf <- parseDomainInput(seedID, domainFile, "file")
# get seedDf and orthoDf
subDf <- domainDf[
    domainDf$seedID ==
    "101621at6656#101621at6656:AGRPL@224129@0:224129_0:001955:1",]
orthoDf <- subDf[subDf$orthoID == "101621at6656:DROME@7227@1:Q9VG04",]
seedDf <- subDf[subDf$orthoID != "101621at6656:DROME@7227@1:Q9VG04",]
# add colors to features
PhyloProfile:::addFeatureColors(seedDf, orthoDf)
}
\author{
Vinh Tran tran@bio.uni-frankfurt.de
}
