% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractProteinMotifs.R
\name{extractProteinMotifs}
\alias{extractProteinMotifs}
\title{Extract protein motifs form a file in PSA format}
\usage{
extractProteinMotifs(file_path)
}
\arguments{
\item{file_path}{A PSA file which specifying the path to the input file.
The file should contain protein motifs.}
}
\value{
A list with a motif identifier (e.g. PSXXXXX) and the coresponding to it motif sequence which is
         associated wuth that identifier.
}
\description{
This function reads a file in PSA format containing protein sequences and extracts motifs based on specific patterns.
}
\examples{
file_path <- system.file("extdata/out_Hb_psa.txt", package = "PMScanR")
if (file_path != "") {
  protein_motifs <- extractProteinMotifs(file_path)
}
}
