% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIUMA_Distances.R
\name{dfToDistance}
\alias{dfToDistance}
\title{Compute the Distance Matrix from TDAobj}
\usage{
dfToDistance(x, distMethod = c("euclidean", "gower", "pearson"))
}
\arguments{
\item{x}{A TDAobj object, generated by \link{makeTDAobj}
Rows (n) and columns (m) should be, respectively, observations and features.}

\item{distMethod}{The distance method to calculate the distance matix.
"euclidean", "gower" and "pearson" values are allowed. Default: "euclidean".}
}
\value{
The starting TDAobj object, in which the computed distance matrix
has been added (slot: 'dist_mat')
}
\description{
This function returns the distance matrix computed by using the
 Pearson's, Euclidean or Gower distance methods. The distances are
computed between the rows of a data.frame in the classical form n x m,
 where n (rows) are observations and m (columns) are features.
}
\examples{
## use example data:
data(tda_test_data)
dfDist <- dfToDistance(tda_test_data, "euclidean")

}
\seealso{
\code{\link{makeTDAobj}}
}
\author{
Mattia Chiesa, Laura Ballarini, Luca Piacentini
}
