% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTopGO.R
\name{getTopGO}
\alias{getTopGO}
\title{Get the topGO Object function}
\usage{
getTopGO(annotations, format, foregroundGenes, ontology)
}
\arguments{
\item{annotations}{list of GO annoatations obtained from the formatTopGO()}

\item{format}{Format for the data to be returned in - either 'GO2geneID' or 'geneID2GO'}

\item{foregroundGenes}{List of identifiers for the foreground genes}

\item{ontology}{The ontology for which the enrichment should be done. This
parameter is passed directly to the topGOdata constructor.}
}
\value{
topGO object
}
\description{
The function to create a topGO object containing the GO annotations for the given protein list.
}
\examples{
geneList = list(getProtein(id='YEAST58'),getProtein(id='YEAST00059'))
annotations = formatTopGO(geneList,format='geneID2GO')
library(topGO)
getTopGO(annotations, foregroundGenes = list('YEAST00058'), format = 'geneID2GO', ontology = 'BP')
}
