% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_plots.R
\name{kozakHeatmap}
\alias{kozakHeatmap}
\title{Make sequence region heatmap relative to scoring}
\usage{
kozakHeatmap(
  seqs,
  rate,
  start = 1,
  stop = max(nchar(seqs)),
  center = ceiling((stop - start + 1)/2),
  min.observations = ">q1",
  skip.startCodon = FALSE,
  xlab = "TIS",
  type = "ribo-seq"
)
}
\arguments{
\item{seqs}{the sequences (character vector, DNAStringSet)}

\item{rate}{a scoring vector (equal size to seqs)}

\item{start}{position in seqs to start at (first is 1), default 1.}

\item{stop}{position in seqs to stop at (first is 1),
default max(nchar(seqs)), that is the longest sequence length}

\item{center}{position in seqs to center at (first is 1), center will
be +1 in heatmap}

\item{min.observations}{How many observations per position per letter
to accept? numeric or quantile, default (">q1", bigger than quartile 1
(25 percentile)). You can do (10), to get all with more than
10 observations.}

\item{skip.startCodon}{startCodon is defined as after centering
 (position 1, 2 and 3).
Should they be skipped ? default (FALSE).
Not relevant if you are not doing Translation initiation sites (TIS).}

\item{xlab}{Region you are checking, default (TIS)}

\item{type}{What type is the rate scoring ? default (ribo-seq)}
}
\value{
a ggplot of the heatmap
}
\description{
Given sequences, DNA or RNA.
And some score, ribo-seq fpkm, TE etc.
Create a heatmap divided per letter in seqs, by how strong the score is.
}
\details{
It will create blocks around the highest rate per position
}
\examples{

\dontrun{
if (requireNamespace("BSgenome.Hsapiens.UCSC.hg19")) {
  txdbFile <- system.file("extdata", "hg19_knownGene_sample.sqlite",
                          package = "GenomicFeatures")
  #Extract sequences of Coding sequences.
  cds <- loadRegion(txdbFile, "cds")
  tx <- loadRegion(txdbFile, "mrna")

  # Get region to check
  kozakRegions <- startRegionString(cds, tx, BSgenome.Hsapiens.UCSC.hg19::Hsapiens
                                    , upstream = 4, 5)
  # Some toy ribo-seq fpkm scores on cds
  set.seed(3)
  fpkm <- sample(1:115, length(cds), replace = TRUE)
  kozakHeatmap(kozakRegions, fpkm, 1, 9, skip.startCodon = F)
}
}

}
