% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_helpers.R
\name{fpkm_calc}
\alias{fpkm_calc}
\title{Create normalizations of read counts}
\usage{
fpkm_calc(counts, lengthSize, librarySize)
}
\arguments{
\item{counts}{a list, # of read hits per group}

\item{lengthSize}{a list of lengths per group}

\item{librarySize}{a numeric of size 1, the # of reads in library}
}
\value{
a numeric vector
}
\description{
A helper for [fpkm()]
Normally use function [fpkm()], if you want unusual normalization
, you can use this.
Short for: Fragments per kilobase of transcript per million fragments
Normally used in Translations efficiency calculations
}
\references{
doi: 10.1038/nbt.1621
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{distToTSS}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{insideOutsideORF}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
\keyword{internal}
