% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRA_helper.R
\name{find_url_ebi}
\alias{find_url_ebi}
\title{Locates and check if fastq files exists in ebi}
\usage{
find_url_ebi(
  SRR,
  stop.on.error = FALSE,
  study = NULL,
  ebi_file_format = c("fastq_ftp", "sra_ftp")[1],
  convert_to_ascp = FALSE
)
}
\arguments{
\item{SRR}{character, SRR, ERR or DRR numbers.}

\item{stop.on.error}{logical FALSE, if TRUE will stop
if all files are not found. If FALSE returns empty character vector if error
is catched.}

\item{study}{default NULL, optional PRJ (study id) to speed up search
for URLs.}

\item{ebi_file_format}{character, format of run download, default is fastq (ftp):
\code{c("fastq_ftp", "sra_ftp")[1]}}

\item{convert_to_ascp}{logical, default FALSE. If TRUE use server:
\code{era-fasp@fasp.sra.ebi.ac.uk:}}
}
\value{
full url to fastq files, same length as input
(2 urls for paired end data). Returns empty character() if all
files not found.
}
\description{
Look for files in ebi file servers,
Paired end and single end fastq files.\cr
Fastq ftp url: \code{ftp://ftp.sra.ebi.ac.uk/vol1/fastq}\cr
SRA   ftp url: \code{ftp://ftp.sra.ebi.ac.uk/vol1/srr}\cr
Fastq ASCP url: \code{era-fasp@fasp.sra.ebi.ac.uk:vol1/fastq}\cr
SRA   ASCP url: \code{era-fasp@fasp.sra.ebi.ac.uk:vol1/srr}\cr
}
\examples{
# Test the 3 ways to get fastq files from EBI
# Both single end and paired end data

# Most common: SRR(3 first)/0(2 last)/whole
# Single
ORFik:::find_url_ebi("SRR10503056")
# Paired
ORFik:::find_url_ebi("SRR10500056")

# less common: SRR(3 first)/00(1 last)/whole
# Single
#ORFik:::find_url_ebi("SRR1562873")
# Paired
#ORFik:::find_url_ebi("SRR1560083")
# least common SRR(3 first)/whole
# Single
#ORFik:::find_url_ebi("SRR105687")
# Paired
#ORFik:::find_url_ebi("SRR105788")
}
