% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRA_metadata.R
\name{download_gene_info}
\alias{download_gene_info}
\title{Download summary information of a gene}
\usage{
download_gene_info(gene = "CCND1", organism = "Homo sapiens", by = "symbol")
}
\arguments{
\item{gene}{character, gene name (symbol)}

\item{organism, }{default NULL. Scientific name (e.g. Homo sapiens)}

\item{by}{character, default symbol (search by gene symbol name).
If "ensembl id", it seraches as it is ensembl gene id ENSG.. etc.}
}
\value{
character, summary text for gene from the database.
}
\description{
Uses ncbi gene database summary from RefSeq
}
\examples{
# Wrap in 'try' to avoid wrong bioc test error
try(download_gene_info(gene = "CCND1"))
try(download_gene_info("ENSG00000110092", by = "ensembl_id")) # By ensembl id
try(download_gene_info(gene = "CCND1", organism = "Mus musculus"))
}
