% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_format_conversion.R
\name{convert_bam_to_ofst}
\alias{convert_bam_to_ofst}
\title{Convert libraries to ofst}
\usage{
convert_bam_to_ofst(
  df,
  in_files = filepath(df, "default"),
  out_dir = file.path(libFolder(df, unique_mappers = only_unique_mappers), "ofst"),
  verbose = TRUE,
  strandMode = rep(0, length(in_files)),
  only_unique_mappers = uniqueMappers(df)
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}, or NULL is allowed if
both in_files and out_dir is specified manually.}

\item{in_files}{paths to input files, default:
\code{filepath(df, "default")} with bam format files.}

\item{out_dir}{paths to output files, default
\code{file.path(libFolder(df), "cov_RLE")}.}

\item{verbose}{logical, default TRUE, message about library output status.}

\item{strandMode}{numeric, default 0. Only used for paired end bam files.
One of (0: strand = *, 1: first read of pair is +, 2: first read of pair is -).
See ?strandMode. Note: Sets default to 0 instead of 1, as readGAlignmentPairs uses 1.
This is to guarantee hits, but will also make mismatches of overlapping
transcripts in opposite directions.}

\item{only_unique_mappers}{logical, default \code{uniqueMappers(df)}.
Load file of only unique format type, located in './unique_mappers' relative
to bam files / default files. See ?uniqueMappers for more information.}
}
\value{
invisible(NULL), files saved to disc
}
\description{
Saved by default in folder "ofst" relative to default
libraries of experiment.
Speeds up loading of full files compared to bam by large margins.
}
\details{
If you want to keep bam files loaded or faster conversion if
you already have them loaded, use ORFik::convertLibs instead
}
\examples{
df <- ORFik.template.experiment.zf()
## Usually do default folder, here we use tmpdir
folder_to_save <- file.path(tempdir(), "ofst")
convert_bam_to_ofst(df, out_dir = folder_to_save)
fimport(file.path(folder_to_save, "ribo-seq.ofst"))
folder_to_save_unique <- file.path(tempdir(), "unique_mappers", "ofst")
convert_bam_to_ofst(df, out_dir = folder_to_save_unique, only_unique_mappers = TRUE)
fimport(file.path(folder_to_save_unique, "ribo-seq.ofst"))
}
\seealso{
Other lib_converters: 
\code{\link{convertLibs}()},
\code{\link{convert_to_bigWig}()},
\code{\link{convert_to_covRle}()},
\code{\link{convert_to_covRleList}()}
}
\concept{lib_converters}
