% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SRA_helper.R
\name{rename.SRA.files}
\alias{rename.SRA.files}
\title{Rename SRA files from metadata}
\usage{
rename.SRA.files(files, new_names)
}
\arguments{
\item{files}{a character vector, with full path to all the files}

\item{new_names}{a character vector of new names or
a data.table with metadata to use to rename (usually from SRA metadata).
Priority of renaming from
the metadata is to check for unique names in the LibraryName column,
then the sample_title column if no valid names in LibraryName.
If found and still duplicates, will
add "_rep1", "_rep2" to make them unique. Paired end data will get a extension
of _p1 and _p2. If no valid names, will not
rename, that is keep the SRR numbers, you then can manually rename files
to something more meaningful.}
}
\value{
a character vector of new file names
}
\description{
Rename SRA files from metadata
}
\seealso{
Other sra: 
\code{\link{browseSRA}()},
\code{\link{download.SRA}()},
\code{\link{download.SRA.metadata}()},
\code{\link{download.ebi}()},
\code{\link{get_bioproject_candidates}()},
\code{\link{install.sratoolkit}()}
}
\concept{sra}
\keyword{internal}
