% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORFs_helpers.R
\name{longestORFs}
\alias{longestORFs}
\title{Get longest ORF per stop site}
\usage{
longestORFs(grl)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}}/IRangesList, GRanges/IRanges of ORFs}
}
\value{
a \code{\link{GRangesList}}/IRangesList, GRanges/IRanges
(same as input)
}
\description{
Rule: if seqname, strand and stop site is equal, take longest one.
Else keep.
If IRangesList or IRanges, seqnames are groups, if GRanges or GRangesList
seqnames are the seqlevels (e.g. chromosomes/transcripts)
}
\examples{
ORF1 = GRanges("1", IRanges(10,21), "+")
ORF2 = GRanges("1", IRanges(1,21), "+") # <- longest
grl <- GRangesList(ORF1 = ORF1, ORF2 = ORF2)
longestORFs(grl) # get only longest
}
\seealso{
Other ORFHelpers: 
\code{\link{defineTrailer}()},
\code{\link{mapToGRanges}()},
\code{\link{orfID}()},
\code{\link{startCodons}()},
\code{\link{startSites}()},
\code{\link{stopCodons}()},
\code{\link{stopSites}()},
\code{\link{txNames}()},
\code{\link{uniqueGroups}()},
\code{\link{uniqueOrder}()}
}
\concept{ORFHelpers}
