% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dif_expression_Analysis.R
\name{DEG.analysis}
\alias{DEG.analysis}
\title{Run differential TE analysis}
\usage{
DEG.analysis(
  df,
  target.contrast = design[1],
  design = ORFik::design(df),
  p.value = 0.05,
  counts = countTable(df, "mrna", type = "summarized"),
  batch.effect = TRUE,
  pairs = combn.pairs(unlist(df[, target.contrast])),
  as.data.table = TRUE,
  fitType = c("parametric", "local", "mean", "glmGamPoi"),
  lfcShrinkType = "normal"
)
}
\arguments{
\item{df}{an \code{\link{experiment}} of usually RNA-seq.}

\item{target.contrast}{a character vector, default \code{design[1]}.
The column in the ORFik experiment that represent the comparison contrasts.
By default: the first design factor of the full experimental design.
This is the factor you will do the comparison on. DESeq will normalize
the counts based on the full design, but the log fold change values will
be based on this contrast only. It is usually the 'condition' column.}

\item{design}{a character vector, default \code{design(df.rfp)}.
The full experiment design. Which factors have more than 1 level.
Example: stage column are all HEK293, so it can not be a design factor.
The condition column has 2 possible values, WT and mutant, so it is
a factor of the experiment. Replicates column is not part of design,
that is inserted later with setting \code{batch.effect = TRUE}.
Library type 'libtype' column, can also no be part of initial design,
it is always added inside the function, after initial setup.}

\item{p.value}{a numeric, default 0.05 in interval (0,1). Defines adjusted
p-value to be used as significance threshold for the result groups. I.e.
for exclusive translation group significant subset for p.value = 0.05 means:
TE$padj < 0.05 & Ribo$padj < 0.05 & RNA$padj > 0.05.}

\item{counts}{a SummarizedExperiment, default:
countTable(df, "mrna", type = "summarized"), all transcripts.
Assign a subset if you don't want to analyze all genes.
It is recommended to not subset, to give DESeq2 data for variance analysis.}

\item{batch.effect}{logical, default TRUE. Makes replicate column of the experiment
part of the design.\cr
If you believe you might have batch effects, keep as TRUE.
Batch effect usually means that you have a strong variance between
biological replicates. Check out \code{\link{pcaExperiment}} and see if replicates
cluster together more than the design factor, to verify if you need to set it to TRUE.}

\item{pairs}{list of character pairs, the experiment contrasts. Default:
\code{combn.pairs(unlist(df.rfp[, target.contrast])}}

\item{as.data.table}{logical, default TRUE. Return as data.table or list of DESeq result objects (FALSE).}

\item{fitType}{either "parametric", "local", "mean", or "glmGamPoi"
for the type of fitting of dispersions to the mean intensity.
See \code{\link{estimateDispersions}} for description.}

\item{lfcShrinkType}{character or NULL. Default "normal", which
shrinkage to apply to results for low count gene subset.
This avoids the problem of extreme fold changes,
 when counts are low. See \link[DESeq2]{lfcShrink}.
A note for DTEG.analysis function: The interaction term (TE),
is not shrunked as this is not counts, but a ratio.}
}
\value{
a data.table with columns:
(contrast variable, gene id, regulation status, log fold changes, p.adjust values, mean counts)
}
\description{
Expression analysis of 1 dimension, usually between conditions of RNA-seq.\cr
Using the standardized DESeq2 pipeline flow.\cr
Creates a DESeq model (given x is the target.contrast argument)
 (usually 'condition' column)\cr
1. RNA-seq model: design = ~ x (differences between the x groups in RNA-seq)\cr
}
\details{
#' Analysis is done between each possible
combination of levels in the target contrast If target contrast is the condition column,
with factor levels: WT, mut1 and mut2 with 3 replicates each. You get comparison
of WT vs mut1, WT vs mut2 and mut1 vs mut2. \cr
The respective result categories are defined as:
(given a user defined p value, shown here as 0.05):\cr
Significant -  p-value adjusted < 0.05 (p-value cutoff decided by 'p.value argument)\cr
\cr The LFC values are shrunken by lfcShrink(type = "normal").\cr \cr
Remember that DESeq by default can not
do global change analysis, it can only find subsets with changes in LFC!
}
\examples{
## Simple example (use ORFik template, then use only RNA-seq)
df <- ORFik.template.experiment()
df.rna <- df[df$libtype == "RNA",]
design(df.rna) # The full experimental design
design(df.rna)[1] # Default target contrast
dt <- DEG.analysis(df.rna)
}
\references{
\url{https://doi.org/10.1002/cpmb.108}
}
\seealso{
Other DifferentialExpression: 
\code{\link{DEG.plot.static}()},
\code{\link{DEG_model}()},
\code{\link{DTEG.plot}()},
\code{\link{te.table}()},
\code{\link{te_rna.plot}()}
}
