% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{mp_plot_ord}
\alias{mp_plot_ord}
\alias{mp_plot_ord,MPSE-method}
\alias{mp_plot_ord,MPSE}
\alias{mp_plot_ord,tbl_mpse-method}
\alias{mp_plot_ord,tbl_mpse}
\alias{mp_plot_ord,grouped_df_mpse-method}
\alias{mp_plot_ord,grouped_df_mpse}
\title{Plotting the result of PCA, PCoA, CCA, RDA, NDMS or DCA}
\usage{
mp_plot_ord(
  .data,
  .ord,
  .dim = c(1, 2),
  .group = NULL,
  .starshape = 15,
  .size = 2,
  .alpha = 1,
  .color = "black",
  starstroke = 0.5,
  show.side = TRUE,
  show.adonis = FALSE,
  ellipse = FALSE,
  show.sample = FALSE,
  show.envfit = FALSE,
  p.adjust = NULL,
  filter.envfit = FALSE,
  ...
)

\S4method{mp_plot_ord}{MPSE}(
  .data,
  .ord,
  .dim = c(1, 2),
  .group = NULL,
  .starshape = 15,
  .size = 2,
  .alpha = 1,
  .color = "black",
  starstroke = 0.5,
  show.side = TRUE,
  show.adonis = FALSE,
  ellipse = FALSE,
  show.sample = FALSE,
  show.envfit = FALSE,
  p.adjust = NULL,
  filter.envfit = FALSE,
  ...
)

\S4method{mp_plot_ord}{tbl_mpse}(
  .data,
  .ord,
  .dim = c(1, 2),
  .group = NULL,
  .starshape = 15,
  .size = 2,
  .alpha = 1,
  .color = "black",
  starstroke = 0.5,
  show.side = TRUE,
  show.adonis = FALSE,
  ellipse = FALSE,
  show.sample = FALSE,
  show.envfit = FALSE,
  p.adjust = NULL,
  filter.envfit = FALSE,
  ...
)

\S4method{mp_plot_ord}{grouped_df_mpse}(
  .data,
  .ord,
  .dim = c(1, 2),
  .group = NULL,
  .starshape = 15,
  .size = 2,
  .alpha = 1,
  .color = "black",
  starstroke = 0.5,
  show.side = TRUE,
  show.adonis = FALSE,
  ellipse = FALSE,
  show.sample = FALSE,
  show.envfit = FALSE,
  p.adjust = NULL,
  filter.envfit = FALSE,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object, it is required.}

\item{.ord}{a name of ordination (required), options are PCA, PCoA, DCA, NMDS, RDA, CCA,
but the corresponding calculation methods (mp_cal_pca, mp_cal_pcoa, ...) 
should be done with action="add" before it.}

\item{.dim}{integer which dimensions will be displayed, it should be a vector (length=2) 
default is c(1, 2). if the length is one the default will also be displayed.}

\item{.group}{the column name of variable to be mapped to the color of points (fill character 
of \code{geom_star}) or one specified color code, default is NULL, meaning \code{fill}=NA,
the points are hollow.}

\item{.starshape}{the column name of variable to be mapped to the shapes of points (starshape 
character of \code{geom_star}) or one specified \code{starshape} of point of \code{ggstar},
default is NULL, meaning \code{starshape}=15 (circle point).}

\item{.size}{the column name of variable to be mapped to the size of points (size character of 
\code{geom_star}) or one specified \code{size} of point of \code{ggstar}, default is NULL,
meaning the \code{size}=1.5, the size of points.}

\item{.alpha}{the column name of variable to be mapped to the transparency of points (alpha
character of \code{geom_star}) or one specified \code{alpha} of point of \code{ggstar}.
default is NULL, meaning the \code{alpha}=1, the transparency of points.}

\item{.color}{the column name of variable to be mapped to the color of line of points (color 
character of \code{geom_star}) or one specified \code{starshape} of point of \code{ggstar},
default is NULL, meaning the \code{color} is 'black'.}

\item{starstroke}{numeric the width of edge of points, default is 0.5.}

\item{show.side}{logical whether display the side boxplot with the specified \code{.dim} 
dimensions, default is TRUE.}

\item{show.adonis}{logical whether display the result of \code{mp_adonis} with \code{action='all'},
default is FALSE.}

\item{ellipse}{logical, whether to plot ellipses, default is FALSE. (.group or .color variables 
according to the 'geom', the default geom is path, so .color can be mapped to the corresponding 
variable).}

\item{show.sample}{logical, whether display the sample names of points, default is FALSE.}

\item{show.envfit}{logical, whether display the result after run [mp_envfit()], default is FALSE.}

\item{p.adjust}{a character method of p.adjust \code{\link[stats]{p.adjust}}, default is NULL,
options are 'fdr', 'bonferroni', 'BH' etc.}

\item{filter.envfit}{logical or numeric, whether to remove the no significant environment factor after 
run [mp_envfit()], default is FALSE, meaning do not remove. If it is numeric, meaning the keep p.value
or the adjust p with \code{p.adjust} the factors smaller than the numeric, e.g when filter.envfit=0.05 or
(filter.envfit=TRUE), meaning the factors of p <= 0.05 will be displayed.}

\item{...}{additional parameters, see also the \code{\link[ggplot2]{stat_ellipse}}.}
}
\description{
Plotting the result of PCA, PCoA, CCA, RDA, NDMS or DCA
}
\examples{
\dontrun{
library(vegan)
data(varespec, varechem)
mpse <- MPSE(assays=list(Abundance=t(varespec)), colData=varechem)
envformula <- paste("~", paste(colnames(varechem), collapse="+")) \%>\% as.formula
mpse \%<>\%
mp_cal_cca(.abundance=Abundance, .formula=envformula, action="add") \%>\%
mp_envfit(.ord=CCA, .env=colnames(varechem), permutations=9999, action="add")
mpse
p1 <- mpse \%>\% mp_plot_ord(.ord=CCA, .group=Al, .size=Mn)
p1
p2 <- mpse \%>\% mp_plot_ord(.ord=CCA, .group=Al, .size=Mn, show.sample=TRUE)
p2
p3 <- mpse \%>\% mp_plot_ord(.ord=CCA, .group="blue", .size=Mn, .alpha=0.8, show.sample=TRUE)
p3
p4 <- mpse \%>\% mp_plot_ord(.ord=CCA, .group=Al, .size=Mn, show.sample=TRUE, show.envfit=TRUE)
p4
}
}
\seealso{
[mp_cal_pca()], [mp_cal_pcoa], [mp_cal_nmds], [mp_cal_rda], 
[mp_cal_cca], [mp_envfit()] and [mp_extract_internal_attr()]
}
