% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_adonis_anosim.R
\name{mp_dmn}
\alias{mp_dmn}
\alias{mp_dmn,MPSE-method}
\alias{mp_dmn,MPSE}
\alias{mp_dmn,tbl_mpse-method}
\alias{mp_dmn,tbl_mpse}
\alias{mp_dmn,grouped_df_mpse-method}
\alias{mp_dmn,grouped_df_mpse}
\title{Fit Dirichlet-Multinomial models to MPSE or tbl_mpse}
\usage{
mp_dmn(.data, .abundance, k = 1, seed = 123, mc.cores = 2, action = "get", ...)

\S4method{mp_dmn}{MPSE}(.data, .abundance, k = 1, seed = 123, mc.cores = 2, action = "get", ...)

\S4method{mp_dmn}{tbl_mpse}(.data, .abundance, k = 1, seed = 123, mc.cores = 2, action = "get", ...)

\S4method{mp_dmn}{grouped_df_mpse}(.data, .abundance, k = 1, seed = 123, mc.cores = 2, action = "get", ...)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{The column name of OTU abundance column to be calculate.}

\item{k}{the number of Dirichlet components to fit, default is 1.}

\item{seed}{random number seed to be reproducible, default is 123.}

\item{mc.cores}{The number of cores to use, default is 2.}

\item{action}{character it has three options, 'get' return a 'list' contained 
DMN (default), "add" joins the new information to the input (can be extracted
with mp_extract_internal_attr(name='DMN')), "only" return a non-redundant tibble 
with the just new information a column  contained 'DMN'.}

\item{...}{additional parameters, see also the \code{\link[parallel]{mclapply}}
and \code{\link[DirichletMultinomial]{dmn}}.}
}
\value{
update object or other (refer to action)
}
\description{
Fit Dirichlet-Multinomial models to MPSE or tbl_mpse
}
\examples{
\dontrun{
data(mouse.time.mpse)
res <- mouse.time.mpse \%>\% 
       mp_dmn(.abundance = Abundance, 
              k = seq_len(2), 
              mc.cores = 4, 
              action = 'get')
res
}
}
