% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_alpha.R
\docType{methods}
\name{mp_cal_divergence}
\alias{mp_cal_divergence}
\alias{mp_cal_divergence,MPSE-method}
\alias{mp_cal_divergence,MPSE}
\alias{mp_cal_divergence,tbl_mpse-method}
\alias{mp_cal_divergence,tbl_mpse}
\alias{mp_cal_divergence,grouped_df_mpse-method}
\alias{mp_cal_divergence,grouped_df_mpse}
\title{calculate the divergence with MPSE or tbl_mpse}
\usage{
mp_cal_divergence(
  .data,
  .abundance,
  .name = "divergence",
  reference = "mean",
  distFUN = vegan::vegdist,
  method = "bray",
  action = "add",
  ...
)

\S4method{mp_cal_divergence}{MPSE}(
  .data,
  .abundance,
  .name = "divergence",
  reference = "mean",
  distFUN = vegan::vegdist,
  method = "bray",
  action = "add",
  ...
)

\S4method{mp_cal_divergence}{tbl_mpse}(
  .data,
  .abundance,
  .name = "divergence",
  reference = "mean",
  distFUN = vegan::vegdist,
  method = "bray",
  action = "add",
  ...
)

\S4method{mp_cal_divergence}{grouped_df_mpse}(
  .data,
  .abundance,
  .name = "divergence",
  reference = "mean",
  distFUN = vegan::vegdist,
  method = "bray",
  action = "add",
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{The column name of OTU abundance column to be calculate.}

\item{.name}{the colname name of the divergence results, default is 'divergence'.}

\item{reference}{a no-empty character, either 'median' or 'mean' or the sample 
name, or a numeric vector which has length equal to the number of features,
default is 'mean'.}

\item{distFUN}{the function to calculate the distance between the reference and
samples, default is 'vegan::vegdist'.}

\item{method}{the method to calculate the distance, which will pass to the function
that is specified in 'distFUN', default is 'bray'.}

\item{action}{character it has three options, "add" joins the new information
to the input tbl (default), "only" return a non-redundant tibble with the just
new information, ang 'get' return a 'alphasample' object.}

\item{...}{additional arguments, see also the arguments of 'distFUN' function.}
}
\value{
update object or other (refer to action)
}
\description{
calculate the divergence with MPSE or tbl_mpse
}
\examples{
\dontrun{
# example(mp_cal_divergence, run.dontrun = TRUE) to run the example.
data(mouse.time.mpse)
mouse.time.mpse \%>\% 
  mp_cal_divergence(
    .abundance = Abundance,
    .name = 'divergence.mean',
    distFUN = vegan::vegdist,
    method = 'bray'
  ) \%>\% 
  mp_plot_alpha(
    .alpha = divergence.mean,
    .group = time,
  )
}
}
\seealso{
[mp_plot_alpha()]
}
\author{
Shuangbin Xu
}
