% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_adonis_anosim.R
\name{mp_adonis}
\alias{mp_adonis}
\alias{mp_adonis,MPSE-method}
\alias{mp_adonis,MPSE}
\alias{mp_adonis,tbl_mpse-method}
\alias{mp_adonis,tbl_mpse}
\alias{mp_adonis,grouped_df_mpse-method}
\alias{mp_adonis,grouped_df_mpse}
\title{Permutational Multivariate Analysis of Variance Using Distance Matrices for MPSE or tbl_mpse object}
\usage{
mp_adonis(
  .data,
  .abundance,
  .formula,
  distmethod = "bray",
  action = "get",
  permutations = 999,
  seed = 123,
  ...
)

\S4method{mp_adonis}{MPSE}(
  .data,
  .abundance,
  .formula,
  distmethod = "bray",
  action = "get",
  permutations = 999,
  seed = 123,
  ...
)

\S4method{mp_adonis}{tbl_mpse}(
  .data,
  .abundance,
  .formula,
  distmethod = "bray",
  action = "get",
  permutations = 999,
  seed = 123,
  ...
)

\S4method{mp_adonis}{grouped_df_mpse}(
  .data,
  .abundance,
  .formula,
  distmethod = "bray",
  action = "get",
  permutations = 999,
  seed = 123,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of abundance to be calculated.}

\item{.formula}{Model formula right hand side gives the continuous variables 
or factors, and keep left empty, such as ~ group, it is required.}

\item{distmethod}{character the method to calculate pairwise distances, 
default is 'bray'.}

\item{action}{character "add" joins the cca result to the object, "only" return
a non-redundant tibble with the cca result. "get" return 'cca' object can
be analyzed using the related vegan funtion.}

\item{permutations}{the number of permutations required, default is 999.}

\item{seed}{a random seed to make the adonis analysis reproducible, default is 123.}

\item{...}{additional parameters see also 'adonis2' of vegan.}
}
\value{
update object according action argument
}
\description{
Permutational Multivariate Analysis of Variance Using Distance Matrices for MPSE or tbl_mpse object
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%>\%
  mp_decostand(
     .abundance=Abundance, 
     method="hellinger") \%>\%
  mp_adonis(.abundance=hellinger, 
            .formula=~time, 
            distmethod="bray", 
            permutations=999, # for more robust, set it to 9999. 
            action="get")
}
\author{
Shuangbin Xu
}
