% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-ggdiffbartaxa.R
\name{ggdifftaxbar}
\alias{ggdifftaxbar}
\alias{ggdiffbartaxa}
\alias{ggdifftaxbar,diffAnalysisClass-method}
\alias{ggdifftaxbar,diffAnalysisClass}
\alias{ggdifftaxbar.featureMeanMedian}
\title{significantly discriminative feature barplot}
\usage{
ggdifftaxbar(obj, ...)

ggdiffbartaxa(obj, ...)

\S4method{ggdifftaxbar}{diffAnalysisClass}(
  obj,
  filepath = NULL,
  output = "biomarker_barplot",
  removeUnknown = TRUE,
  figwidth = 6,
  figheight = 3,
  ylabel = "relative abundance",
  format = "pdf",
  dpi = 300,
  ...
)

\method{ggdifftaxbar}{featureMeanMedian}(
  obj,
  featurename,
  classgroup,
  subclass,
  xtextsize = 3,
  factorLevels = NULL,
  coloslist = NULL,
  ylabel = "relative abundance",
  ...
)
}
\arguments{
\item{obj}{object, diffAnalysisClass see also 
\code{\link[MicrobiotaProcess]{diff_analysis}} or feMeanMedian class, 
see also \code{\link[MicrobiotaProcess]{get_mean_median}}.}

\item{...}{additional arguments.}

\item{filepath}{character, default is NULL, meaning current path.}

\item{output}{character, the output dir name, default is "biomarker_barplot".}

\item{removeUnknown}{logical, whether do not show unknown taxonomy, default is TRUE.}

\item{figwidth}{numeric, the width of figures, default is 6.}

\item{figheight}{numeric, the height of figures, default is 3.}

\item{ylabel}{character, the label of y, default is 'relative abundance'.}

\item{format}{character, the format of figure, default is pdf,
png, tiff also be supported.}

\item{dpi}{numeric, the dpi of output, default is 300.}

\item{featurename}{character, the feature name, contained at the objet.}

\item{classgroup}{character, factor name.}

\item{subclass}{character, factor name.}

\item{xtextsize}{numeric, the size of axis x label, default is 3.}

\item{factorLevels}{list,  the levels of the factors, default is NULL,
if you want to order the levels of factor, you can set this.}

\item{coloslist}{vector, color vector, if the input is phyloseq, 
you should use this to adjust the color, not scale_color_manual.}
}
\value{
the figures of features show the distributions in samples.
}
\description{
significantly discriminative feature barplot
}
\examples{
\dontrun{
data(kostic2012crc)
kostic2012crc \%<>\% as.phyloseq()
head(phyloseq::sample_data(kostic2012crc),3)
kostic2012crc <- phyloseq::rarefy_even_depth(kostic2012crc,
                              rngseed=1024)
table(phyloseq::sample_data(kostic2012crc)$DIAGNOSIS)
set.seed(1024)
diffres <- diff_analysis(kostic2012crc, classgroup="DIAGNOSIS",
                        mlfun="lda", filtermod="fdr",
                        firstcomfun = "kruskal.test",
                        firstalpha=0.05, strictmod=TRUE,
                        secondcomfun = "wilcox.test",
                        subclmin=3, subclwilc=TRUE,
                        secondalpha=0.01, ldascore=3)
ggdifftaxbar(diffres, output="biomarker_barplot")
}
}
\author{
Shuangbin Xu
}
