% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-ggbartaxa.R
\name{ggbartax}
\alias{ggbartax}
\alias{ggbartaxa}
\alias{ggbartax.phyloseq}
\alias{ggbartax.data.frame}
\title{taxonomy barplot}
\usage{
ggbartax(obj, ...)

ggbartaxa(obj, ...)

\method{ggbartax}{phyloseq}(obj, ...)

\method{ggbartax}{data.frame}(
  obj,
  mapping = NULL,
  position = "stack",
  stat = "identity",
  width = 0.7,
  topn = 30,
  count = FALSE,
  sampleda = NULL,
  factorLevels = NULL,
  sampleLevels = NULL,
  facetNames = NULL,
  plotgroup = FALSE,
  groupfun = mean,
  ...
)
}
\arguments{
\item{obj}{phyloseq, phyloseq class or data.frame, 
(nrow sample * ncol feature (factor)) or the data.frame for geom_bar.}

\item{...}{additional parameters, see \code{\link[ggplot2]{ggplot}}}

\item{mapping}{set of aesthetic mapping of ggplot2, default is NULL,
if the data is the data.frame for geom_bar, the mapping should be set.}

\item{position}{character, default is `stack`.}

\item{stat}{character, default is `identity`.}

\item{width}{numeric, the width of bar, default is 0.7.}

\item{topn}{integer, the top number of abundance taxonomy(feature).}

\item{count}{logical, whether show the relative abundance.}

\item{sampleda}{data.frame, (nrow sample * ncol factor), the sample 
information, if the data doesn't contain the information.}

\item{factorLevels}{vector or list, the levels of the factors
(contained names e.g. list(group=c("B","A","C")) or
c(group=c("B","A","C"))), adjust the order of facet, default is NULL,
if you want to order the levels of factor, you can set this.}

\item{sampleLevels}{vector, adjust the order of x axis
e.g. c("sample2", "sample4", "sample3"), default is NULL.}

\item{facetNames}{character, default is NULL.}

\item{plotgroup}{logical, whether calculate the mean or median etc 
for each group, default is FALSE.}

\item{groupfun}{character, how to calculate for feature in each group,
the default is `mean`, this will plot the mean of feature in each group.}
}
\value{
barplot of tax
}
\description{
taxonomy barplot
}
\examples{
\dontrun{
    library(ggplot2)
    data(test_otu_data)
    test_otu_data \%<>\% as.phyloseq()
    otubar <- ggbartax(test_otu_data) + 
              xlab(NULL) + ylab("relative abundance(\%)")
}
}
\author{
Shuangbin Xu
}
