% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_dynamics.R
\name{heatmap_dynamics}
\alias{heatmap_dynamics}
\title{plot bubble heatmap from the numerical fit of compare_dynamics()}
\usage{
heatmap_dynamics(
  estimates = metadata(data)[["comparison_dynamics"]][["estimates"]],
  data
)
}
\arguments{
\item{estimates}{dataframe of estimates of the mean distance
between clusters of different experimental conditions ("mean") and the
standard deviation ("sigma") obtain by function compare_dynamics()}

\item{data}{a dataframe or containing a column specifying the metabolite
names to be compared and cluster IDs (column named "cluster") of
clusters of similar dynamics, as well as a column "condition" specifying
the experimental conditions.
to be compared or a \link[SummarizedExperiment]{SummarizedExperiment} storing the same information in
metadata(data) under "cluster"}
}
\value{
a bubble heat map where the color of the bubble represents the similarity
of two clusters in regards to their dynamics in the color and the size the
uncertainty of the similarity. Big bright bubbles mean high similarity with
low uncertainty.
}
\description{
plot bubble heatmap from the numerical fit of compare_dynamics()
}
\examples{
data("longitudinalMetabolomics")
data <- longitudinalMetabolomics[, longitudinalMetabolomics$condition \%in\% c("A", "B") &
  longitudinalMetabolomics$metabolite \%in\% c("ATP", "L-Alanine", "GDP")]
data <- fit_dynamics_model(
  data = data,
  scaled_measurement = "m_scaled", assay = "scaled_log",
  max_treedepth = 14, adapt_delta = 0.95, iter = 2000, cores = 1, chains = 1
)
data <- estimates_dynamics(
  data = data
)
data <- cluster_dynamics(data, B = 1)
data <- compare_dynamics(
  data = data,
  cores = 1
)
S4Vectors::metadata(data)[["comparison_dynamics"]]
heatmap_dynamics(data = data)
}
\seealso{
Do calculations for comparison of dynamics between clusters \code{\link[=compare_dynamics]{compare_dynamics()}}
}
