% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics_dynamics.R
\name{diagnostics_dynamics}
\alias{diagnostics_dynamics}
\title{Extracts diagnostic criteria from numeric fit of Bayesian model of dynamics}
\usage{
diagnostics_dynamics(
  data,
  assay = "scaled_log",
  iter = 2000,
  warmup = iter/4,
  chains = 4,
  fit = metadata(data)[["dynamic_fit"]]
)
}
\arguments{
\item{data}{dataframe or a \link[SummarizedExperiment]{SummarizedExperiment} used to fit dynamics model
column of "time" that contains time must be numeric, has to contain columns
specifying the metabolite named "metabolite", and column specifiying the time
point named "time", a column named "condition" must specify the experimental condition.}

\item{assay}{of the SummarizedExperiment object that was used to fit the dynamics
model}

\item{iter}{number of iterations used for model fit}

\item{warmup}{number of warmup iterations used for model fit}

\item{chains}{number of chains used for model fit}

\item{fit}{model fit for which diagnostics should be extracted, is the
object that gets returned by fit_dynamics_model(), or if a SummarizedExperiment
object the results of fit_dynamics_model() are stored in metadata(data) under
"dynamic_fit"}
}
\value{
a list which contains diagnostics criteria of all conditions in a
dataframe (named "model_diagnostics") and one dataframe per condition that
contains necessary information for Posterior predictive check
(named "PPC_condition"). If data is a summarizedExperiment object the diagnostics
are stored in metadata(data) "diagnostics_dynamics"
}
\description{
gathers number of divergences, rhat values, number of effective
samples (n_eff) and provides plots for diagnostics criteria as well as
posterior predictive checks. Output dataframe "model_diagnostics" contains
information about experimental condition, number of divergent transitions
and rhat and neff values for all timepoints.
}
\examples{
data("longitudinalMetabolomics")
data <- longitudinalMetabolomics[, longitudinalMetabolomics$condition \%in\% c("A", "B") &
  longitudinalMetabolomics$metabolite == "ATP"]
data <- fit_dynamics_model(
  model = "scaled_log",
  data = data,
  scaled_measurement = "m_scaled", assay = "scaled_log",
  max_treedepth = 14, adapt_delta = 0.95, iter = 2000, cores = 1, chains = 1
)
data <- diagnostics_dynamics(
  data = data, assay = "scaled_log",
  iter = 2000, chains = 1,
  fit = metadata(data)[["dynamic_fit"]]
)
S4Vectors::metadata(data)[["diagnostics_dynamics"]][["model_diagnostics"]]
S4Vectors::metadata(data)[["diagnostics_dynamics"]][["posterior"]]

}
\seealso{
\code{\link[=estimates_dynamics]{estimates_dynamics()}}
parent function \code{\link[=fit_dynamics_model]{fit_dynamics_model()}}
visualization functions: \code{\link[=plot_diagnostics]{plot_diagnostics()}}/\code{\link[=plot_PPC]{plot_PPC()}}
}
