% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diagnostics.R
\name{plot_diagnostics}
\alias{plot_diagnostics}
\title{Plot diagnostic criteria of numerical fit of Bayesian model of dynamics}
\usage{
plot_diagnostics(
  data,
  assay = "scaled_log",
  diagnostics = metadata(data)[["diagnostics_dynamics"]][["model_diagnostics"]],
  divergences = TRUE,
  max_treedepth = TRUE,
  Rhat = TRUE,
  n_eff = TRUE
)
}
\arguments{
\item{data}{dataframe or colData of a \link[SummarizedExperiment]{SummarizedExperiment}  used to fit dynamics model
must contain column "time"}

\item{assay}{of the \link[SummarizedExperiment]{SummarizedExperiment} object that was used to fit the dynamics
model}

\item{diagnostics}{dataframe containing diagnostics criteria from the numerical
fit of Bayesian model of dynamics obtained by function diagnostics_dynamics()}

\item{divergences}{should number of divergent transitions be visualized?}

\item{max_treedepth}{should number of exeeded maximum treedepth be visualized?}

\item{Rhat}{should Rhat be visualized?}

\item{n_eff}{should number of effective samples be visualized?}
}
\value{
plots of diagnostic criteria of numerical fit of Bayesian model of
dynamics
}
\description{
Plot diagnostic criteria of numerical fit of Bayesian model of dynamics
}
\examples{
data("longitudinalMetabolomics")
data <- longitudinalMetabolomics[, longitudinalMetabolomics$condition == "A" &
  longitudinalMetabolomics$metabolite \%in\% c("ATP", "ADP")]
data <- fit_dynamics_model(
  model = "scaled_log",
  data = data,
  scaled_measurement = "m_scaled", assay = "scaled_log",
  max_treedepth = 14, adapt_delta = 0.95, iter = 2000, cores = 1, chains = 1
)
data <- diagnostics_dynamics(
  data = data, assay = "scaled_log",
  iter = 2000, chains = 1,
  fit = metadata(data)[["dynamic_fit"]]
)
plot_diagnostics(data = data, assay = "scaled_log")

}
\seealso{
parent function \code{\link[=diagnostics_dynamics]{diagnostics_dynamics()}}
visualization function for posterior predictive check \code{\link[=plot_PPC]{plot_PPC()}}
}
