% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adducts.R
\name{formula2mz}
\alias{formula2mz}
\title{Calculate mass-to-charge ratio from a formula}
\usage{
formula2mz(formula, adduct = "[M+H]+", standardize = TRUE)
}
\arguments{
\item{formula}{\code{character} with one or more valid molecular formulas for
which their adduct m/z shall be calculated.}

\item{adduct}{either a \code{character} specifying the name(s) of the adduct(s)
for which the m/z should be calculated or a \code{data.frame} with the adduct
definition. See \code{\link[=adductNames]{adductNames()}} for supported adduct names and the
description for more information on the expected format if a \code{data.frame}
is provided.}

\item{standardize}{\code{logical} whether to standardize the molecular formulas
to the Hill notation system before calculating their mass.}
}
\value{
Numeric \code{matrix} with same number of rows than elements in \code{formula}
and number of columns being equal to the length of \code{adduct} (adduct names
are used as column names). Each column thus represents the m/z of \code{formula}
for each defined \code{adduct}.
}
\description{
\code{formula2mz} calculates the m/z values from a list of molecular formulas and
adduct definitions.

Custom adduct definitions can be passed to the \code{adduct} parameter in form of
a \code{data.frame}. This \code{data.frame} is expected to have columns \code{"mass_add"}
and \code{"mass_multi"} defining the \emph{additive} and \emph{multiplicative} part of the
calculation. See \code{\link[=adducts]{adducts()}} for examples.
}
\examples{
## Calculate m/z values of adducts of a list of formulas
formulas <- c("C6H12O6", "C9H11NO3", "C16H13ClN2O")
ads <- c("[M+H]+", "[M+Na]+", "[2M+H]+", "[M]+")
formula2mz(formulas, ads)
formula2mz(formulas, adductNames()) #All available adducts

## Use custom-defined adducts as input
custom_ads <- data.frame(mass_add = c(1, 2, 3), mass_multi = c(1, 2, 0.5))
formula2mz(formulas, custom_ads)

## Use standardize = FALSE to keep formula unaltered
formula2mz("H12C6O6")
formula2mz("H12C6O6", standardize = FALSE)
}
\author{
Roger Gine
}
